/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.iceberg;

import io.trino.tempto.AfterMethodWithContext;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestIcebergCreateTable
extends ProductTest {
    @BeforeMethodWithContext
    public void setUp() {
        QueryExecutors.onTrino().executeQuery("CREATE SCHEMA IF NOT EXISTS iceberg.iceberg", new QueryExecutor.QueryParam[0]);
    }

    @AfterMethodWithContext
    public void cleanUp() {
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA iceberg.iceberg", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "storage_formats", "hms_only"})
    public void testCreateTable() {
        String tableName = "iceberg.iceberg.test_create_table_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + tableName + "(a bigint, b varchar)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("INSERT INTO " + tableName + "(a, b) VALUES (NULL, NULL), (-42, 'abc'), (9223372036854775807, 'abcdefghijklmnopqrstuvwxyz')", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{null, null}), QueryAssert.Row.row((Object[])new Object[]{-42, "abc"}), QueryAssert.Row.row((Object[])new Object[]{Long.MAX_VALUE, "abcdefghijklmnopqrstuvwxyz"})});
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"iceberg", "storage_formats", "hms_only"})
    public void testCreateTableAsSelect() {
        String tableName = "iceberg.iceberg.test_create_table_as_select_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + tableName + " AS SELECT * FROM (VALUES   (NULL, NULL),   (-42, 'abc'),   (9223372036854775807, 'abcdefghijklmnopqrstuvwxyz')) t(a, b)", new QueryExecutor.QueryParam[0]);
        try {
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{null, null}), QueryAssert.Row.row((Object[])new Object[]{-42, "abc"}), QueryAssert.Row.row((Object[])new Object[]{Long.MAX_VALUE, "abcdefghijklmnopqrstuvwxyz"})});
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }
}

