/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.snowflake;

import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.tests.product.utils.QueryExecutors;
import org.testng.annotations.Test;

public class TestSnowflake
extends ProductTest {
    @Test(groups={"snowflake", "profile_specific_tests"})
    public void testCreateTableAsSelect() {
        String tableName = "snowflake.tpch.nation_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        QueryResult result = QueryExecutors.onTrino().executeQuery("CREATE TABLE " + tableName + " AS SELECT * FROM tpch.tiny.nation", new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertThat((QueryResult)result).updatedRowsCountIsEqualTo(25);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT COUNT(*) FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25})});
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }
}

