/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.teradata;

import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestTeradataFunctions
extends ProductTest {
    @Test(groups={"functions"})
    public void testIndex() {
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT index('high', 'ig')", new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
    }

    @Test(groups={"functions"})
    public void testChar2HexInt() {
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT char2hexint('\u0ca0\u76ca\u0ca0')", new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"0CA076CA0CA0"})});
    }

    @Test(groups={"functions"})
    public void testToDate() {
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT to_date('1988/04/01', 'yyyy/mm/dd')", new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{Date.valueOf("1988-04-01")})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT to_date('1988/04/08', 'yyyy/mm/dd')", new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{Date.valueOf("1988-04-08")})});
    }

    @Test(groups={"functions"})
    public void testToTimestamp() {
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT to_timestamp('1988/04/08;02:03:04','yyyy/mm/dd;hh24:mi:ss')", new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{Timestamp.valueOf(LocalDateTime.of(1988, 4, 8, 2, 3, 4))})});
    }

    @Test(groups={"functions"})
    public void testToChar() {
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT to_char(TIMESTAMP '1988-04-08 14:15:16 +02:09','yyyy/mm/dd;hh24:mi:ss')", new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1988/04/08;14:15:16"})});
    }
}

