/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;

public abstract class BaseTestTableFormats
extends ProductTest {
    protected abstract String getCatalogName();

    protected void testCreateAndSelectNationTable(String schemaLocation) {
        String tableName = "nation_" + TestingNames.randomNameSuffix();
        String tableLocation = schemaLocation + "/" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %1$s.default.%2$s WITH (location = '%3$s/%2$s') AS SELECT * FROM tpch.tiny.nation", this.getCatalogName(), tableName, tableLocation), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM %1$s.default.%2$s", this.getCatalogName(), tableName), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25})});
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %1$s.default.%2$s", this.getCatalogName(), tableName), new QueryExecutor.QueryParam[0]);
    }

    protected void testBasicWriteOperations(String schemaLocation) {
        String tableName = "table_write_operations_" + TestingNames.randomNameSuffix();
        String tableLocation = schemaLocation + "/" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %1$s.default.%2$s (a_bigint bigint, a_varchar varchar) WITH (location = '%3$s/%2$s')", this.getCatalogName(), tableName, tableLocation), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %1$s.default.%2$s VALUES (1, 'hello world')".formatted(this.getCatalogName(), tableName), new Object[0]), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %1$s.default.%2$s", this.getCatalogName(), tableName), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1L, "hello world"})});
        QueryExecutors.onTrino().executeQuery(String.format("UPDATE %1$s.default.%2$s SET a_varchar = 'hallo Welt' WHERE a_bigint = 1".formatted(this.getCatalogName(), tableName), new Object[0]), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %1$s.default.%2$s", this.getCatalogName(), tableName), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1L, "hallo Welt"})});
        QueryExecutors.onTrino().executeQuery(String.format("DELETE FROM %1$s.default.%2$s WHERE a_bigint = 1".formatted(this.getCatalogName(), tableName), new Object[0]), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %1$s.default.%2$s", this.getCatalogName(), tableName), new QueryExecutor.QueryParam[0]))).hasNoRows();
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %1$s.default.%2$s", this.getCatalogName(), tableName), new QueryExecutor.QueryParam[0]);
    }

    protected void testCreateAndInsertTable(String schemaLocation) {
        String tableName = "table_write_operations_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery(String.format("CREATE SCHEMA %s.test WITH (location = '%s')", this.getCatalogName(), schemaLocation), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s.test.%s (a_bigint bigint, a_varchar varchar)", this.getCatalogName(), tableName), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s.test.%s VALUES (1, 'hello world')".formatted(this.getCatalogName(), tableName), new Object[0]), new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM %s.test.%s".formatted(this.getCatalogName(), tableName), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1L, "hello world"})});
        }
        catch (Throwable throwable) {
            QueryExecutors.onTrino().executeQuery("DROP SCHEMA %s.test CASCADE".formatted(this.getCatalogName()), new QueryExecutor.QueryParam[0]);
            throw throwable;
        }
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA %s.test CASCADE".formatted(this.getCatalogName()), new QueryExecutor.QueryParam[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testPathContainsSpecialCharacter(String schemaLocation, String partitioningPropertyName) {
        String tableName = "test_path_special_character" + TestingNames.randomNameSuffix();
        try {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE SCHEMA %1$s.test WITH (location = '%2$s')", this.getCatalogName(), schemaLocation), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %1$s.test.%2$s (id bigint, part varchar) WITH (%3$s = ARRAY['part'])", this.getCatalogName(), tableName, partitioningPropertyName), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO " + this.getCatalogName() + ".test." + tableName + " VALUES (1, 'with-hyphen'),(2, 'with.dot'),(3, 'with:colon'),(4, 'with/slash'),(5, 'with\\\\backslashes'),(6, 'with\\backslash'),(7, 'with=equal'),(8, 'with?question'),(9, 'with!exclamation'),(10, 'with%percent'),(11, 'with%%percents'),(12, 'with space')", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "with-hyphen"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "with.dot"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "with:colon"}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "with/slash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, "with\\\\backslashes"}), (Object)QueryAssert.Row.row((Object[])new Object[]{6, "with\\backslash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{7, "with=equal"}), (Object)QueryAssert.Row.row((Object[])new Object[]{8, "with?question"}), (Object)QueryAssert.Row.row((Object[])new Object[]{9, "with!exclamation"}), (Object)QueryAssert.Row.row((Object[])new Object[]{10, "with%percent"}), (Object)QueryAssert.Row.row((Object[])new Object[]{11, "with%%percents"}), (Object)QueryAssert.Row.row((Object[])new Object[]{12, "with space"}), (Object[])new QueryAssert.Row[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %1$s.test.%2$s", this.getCatalogName(), tableName), new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            if (!this.getCatalogName().equalsIgnoreCase("delta")) {
                ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onSpark().executeQuery(String.format("SELECT * FROM %1$s.test.%2$s", this.getSparkCatalog(), tableName), new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            }
        }
        catch (Throwable throwable) {
            QueryExecutors.onTrino().executeQuery("DROP TABLE %1$s.test.%2$s".formatted(this.getCatalogName(), tableName), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DROP SCHEMA %1$s.test".formatted(this.getCatalogName()), new QueryExecutor.QueryParam[0]);
            throw throwable;
        }
        QueryExecutors.onTrino().executeQuery("DROP TABLE %1$s.test.%2$s".formatted(this.getCatalogName(), tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA %1$s.test".formatted(this.getCatalogName()), new QueryExecutor.QueryParam[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testSparkCompatibilityOnTrinoCreatedTable(String schemaLocation) {
        String baseTableName = "trino_created_table_using_parquet_" + TestingNames.randomNameSuffix();
        String sparkTableName = String.format("%s.test_compat.%s", this.getSparkCatalog(), baseTableName);
        String trinoTableName = String.format("%s.test_compat.%s", this.getCatalogName(), baseTableName);
        try {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE SCHEMA %s.test_compat WITH (location = '%s')", this.getCatalogName(), schemaLocation), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("CREATE TABLE " + trinoTableName + "(a_boolean boolean, a_varchar varchar) WITH (format = 'PARQUET')", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO " + trinoTableName + " VALUES (true, 'test data')", new QueryExecutor.QueryParam[0]);
            List<QueryAssert.Row> expected = List.of(QueryAssert.Row.row((Object[])new Object[]{true, "test data"}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + trinoTableName, new QueryExecutor.QueryParam[0]))).containsOnly(expected);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onSpark().executeQuery("SELECT * FROM " + sparkTableName, new QueryExecutor.QueryParam[0]))).containsOnly(expected);
        }
        catch (Throwable throwable) {
            QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + trinoTableName, new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DROP SCHEMA IF EXISTS %s.test_compat".formatted(this.getCatalogName()), new QueryExecutor.QueryParam[0]);
            throw throwable;
        }
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + trinoTableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA IF EXISTS %s.test_compat".formatted(this.getCatalogName()), new QueryExecutor.QueryParam[0]);
    }

    protected String getSparkCatalog() {
        return "spark_catalog";
    }
}

