/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.tempto.Requirement;
import io.trino.tempto.fulfillment.ldap.LdapObjectDefinition;
import io.trino.tempto.fulfillment.ldap.LdapObjectRequirement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class ImmutableLdapObjectDefinitions {
    private static final String DOMAIN = "dc=trino,dc=testldap,dc=com";
    private static final String AMERICA_DISTINGUISHED_NAME = String.format("ou=America,%s", "dc=trino,dc=testldap,dc=com");
    private static final String ASIA_DISTINGUISHED_NAME = String.format("ou=Asia,%s", "dc=trino,dc=testldap,dc=com");
    private static final String EUROPE_DISTINGUISHED_NAME = String.format("ou=Europe,%s", "dc=trino,dc=testldap,dc=com");
    private static final String LDAP_PASSWORD = "LDAPPass123";
    private static final String MEMBER = "member";
    public static final LdapObjectDefinition AMERICA_ORG = ImmutableLdapObjectDefinitions.buildLdapOrganizationObject("America", AMERICA_DISTINGUISHED_NAME, "America");
    public static final LdapObjectDefinition ASIA_ORG = ImmutableLdapObjectDefinitions.buildLdapOrganizationObject("Asia", ASIA_DISTINGUISHED_NAME, "Asia");
    public static final LdapObjectDefinition EUROPE_ORG = ImmutableLdapObjectDefinitions.buildLdapOrganizationObject("Europe", EUROPE_DISTINGUISHED_NAME, "Europe");
    public static final LdapObjectDefinition DEFAULT_GROUP_USER = ImmutableLdapObjectDefinitions.buildLdapUserObject("DefaultGroupUser", "LDAPPass123");
    public static final LdapObjectDefinition PARENT_GROUP_USER = ImmutableLdapObjectDefinitions.buildLdapUserObject("ParentGroupUser", "LDAPPass123");
    public static final LdapObjectDefinition CHILD_GROUP_USER = ImmutableLdapObjectDefinitions.buildLdapUserObject("ChildGroupUser", "LDAPPass123");
    public static final LdapObjectDefinition ORPHAN_USER = ImmutableLdapObjectDefinitions.buildLdapUserObject("OrphanUser", "LDAPPass123");
    public static final LdapObjectDefinition SPECIAL_USER = ImmutableLdapObjectDefinitions.buildLdapUserObject("User WithSpecialPwd", "LDAP:Pass ~!@#$%^&*()_+{}|:\"<>?/.,';\\][=-`");
    public static final LdapObjectDefinition USER_IN_MULTIPLE_GROUPS = ImmutableLdapObjectDefinitions.buildLdapUserObject("UserInMultipleGroups", "LDAPPass123");
    public static final LdapObjectDefinition USER_IN_EUROPE = ImmutableLdapObjectDefinitions.buildLdapUserObject("EuropeUser", EUROPE_DISTINGUISHED_NAME, "LDAPPass123");
    public static final LdapObjectDefinition USER_IN_AMERICA = ImmutableLdapObjectDefinitions.buildLdapUserObject("AmericanUser", AMERICA_DISTINGUISHED_NAME, "LDAPPass123");
    public static final LdapObjectDefinition CHILD_GROUP = ImmutableLdapObjectDefinitions.buildLdapGroupObject("ChildGroup", "ChildGroupUser", (List<LdapObjectDefinition>)ImmutableList.of());
    public static final LdapObjectDefinition DEFAULT_GROUP = ImmutableLdapObjectDefinitions.buildLdapGroupObject("DefaultGroup", "DefaultGroupUser", (List<LdapObjectDefinition>)ImmutableList.of((Object)CHILD_GROUP, (Object)SPECIAL_USER, (Object)USER_IN_MULTIPLE_GROUPS, (Object)USER_IN_EUROPE, (Object)USER_IN_AMERICA));
    public static final LdapObjectDefinition PARENT_GROUP = ImmutableLdapObjectDefinitions.buildLdapGroupObject("ParentGroup", "ParentGroupUser", (List<LdapObjectDefinition>)ImmutableList.of((Object)DEFAULT_GROUP, (Object)USER_IN_MULTIPLE_GROUPS));

    private ImmutableLdapObjectDefinitions() {
    }

    public static Requirement getLdapRequirement() {
        return new LdapObjectRequirement((List)ImmutableList.of((Object)AMERICA_ORG, (Object)ASIA_ORG, (Object)EUROPE_ORG, (Object)DEFAULT_GROUP_USER, (Object)PARENT_GROUP_USER, (Object)CHILD_GROUP_USER, (Object)ORPHAN_USER, (Object)SPECIAL_USER, (Object)USER_IN_MULTIPLE_GROUPS, (Object)USER_IN_AMERICA, (Object)USER_IN_EUROPE, (Object)DEFAULT_GROUP, (Object[])new LdapObjectDefinition[]{PARENT_GROUP, CHILD_GROUP}));
    }

    public static LdapObjectDefinition buildLdapOrganizationObject(String id, String distinguishedName, String unit) {
        return LdapObjectDefinition.builder((String)id).setDistinguishedName(distinguishedName).setAttributes((Map)ImmutableMap.of((Object)"ou", (Object)unit)).setObjectClasses(Arrays.asList("top", "organizationalUnit")).build();
    }

    public static LdapObjectDefinition buildLdapGroupObject(String groupName, String userName, List<LdapObjectDefinition> memberAttributes) {
        return ImmutableLdapObjectDefinitions.buildLdapGroupObject(groupName, AMERICA_DISTINGUISHED_NAME, userName, ASIA_DISTINGUISHED_NAME, memberAttributes);
    }

    public static LdapObjectDefinition buildLdapGroupObject(String groupName, String groupOrganizationName, String userName, String userOrganizationName, List<LdapObjectDefinition> memberAttributes) {
        return LdapObjectDefinition.builder((String)groupName).setDistinguishedName(String.format("cn=%s,%s", groupName, groupOrganizationName)).setAttributes((Map)ImmutableMap.of((Object)"cn", (Object)groupName, (Object)MEMBER, (Object)String.format("uid=%s,%s", userName, userOrganizationName))).setModificationAttributes((Map)ImmutableMap.of((Object)MEMBER, (Object)((List)memberAttributes.stream().map(LdapObjectDefinition::getDistinguishedName).collect(ImmutableList.toImmutableList())))).setObjectClasses(Arrays.asList("groupOfNames")).build();
    }

    public static LdapObjectDefinition buildLdapUserObject(String userName, String password) {
        return ImmutableLdapObjectDefinitions.buildLdapUserObject(userName, ASIA_DISTINGUISHED_NAME, password);
    }

    public static LdapObjectDefinition buildLdapUserObject(String userName, String userOrganizationName, String password) {
        return LdapObjectDefinition.builder((String)userName).setDistinguishedName(String.format("uid=%s,%s", userName, userOrganizationName)).setAttributes((Map)ImmutableMap.of((Object)"cn", (Object)userName, (Object)"sn", (Object)userName, (Object)"userPassword", (Object)password)).setObjectClasses(Arrays.asList("person", "inetOrgPerson")).build();
    }
}

