/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.AfterMethodWithContext;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.hadoop.hdfs.HdfsClient;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.utils.QueryExecutors;
import java.net.URI;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestImpersonation
extends ProductTest {
    private QueryExecutor aliceExecutor;
    private QueryExecutor bobExecutor;
    @Inject
    private HdfsClient hdfsClient;
    @Inject
    @Named(value="databases.alice@presto.jdbc_user")
    private String aliceJdbcUser;
    @Inject
    @Named(value="databases.bob@presto.jdbc_user")
    private String bobJdbcUser;
    @Inject
    @Named(value="databases.presto.configured_hdfs_user")
    private String configuredHdfsUser;
    @Inject
    @Named(value="databases.hive.warehouse_directory_path")
    private String warehouseLocation;

    @BeforeMethodWithContext
    public void setup() {
        this.aliceExecutor = QueryExecutors.connectToTrino("alice@presto");
        this.bobExecutor = QueryExecutors.connectToTrino("bob@presto");
    }

    @AfterMethodWithContext
    public void cleanup() {
        this.aliceExecutor = null;
        this.bobExecutor = null;
    }

    @Test(groups={"hdfs_impersonation", "profile_specific_tests"})
    public void testExternalLocationTableCreationFailure() {
        String commonExternalLocationPath = this.warehouseLocation + "/nested_" + TestingNames.randomNameSuffix();
        String tableNameBob = "bob_external_table" + TestingNames.randomNameSuffix();
        String tableLocationBob = commonExternalLocationPath + "/bob_table";
        this.bobExecutor.executeQuery(String.format("CREATE TABLE %s (a bigint) WITH (external_location = '%s')", tableNameBob, tableLocationBob), new QueryExecutor.QueryParam[0]);
        String owner = this.hdfsClient.getOwner(commonExternalLocationPath);
        Assertions.assertThat((String)owner).isEqualTo(this.bobJdbcUser);
        String tableNameAlice = "alice_external_table" + TestingNames.randomNameSuffix();
        String tableLocationAlice = commonExternalLocationPath + "/alice_table";
        QueryAssert.assertQueryFailure(() -> this.aliceExecutor.executeQuery(String.format("CREATE TABLE %s (a bigint) WITH (external_location = '%s')", tableNameAlice, tableLocationAlice), new QueryExecutor.QueryParam[0])).hasStackTraceContaining("Permission denied");
        this.bobExecutor.executeQuery(String.format("DROP TABLE IF EXISTS %s", tableNameBob), new QueryExecutor.QueryParam[0]);
        this.aliceExecutor.executeQuery(String.format("DROP TABLE IF EXISTS %s", tableNameAlice), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hdfs_no_impersonation", "profile_specific_tests"})
    public void testExternalLocationTableCreationSuccess() {
        String commonExternalLocationPath = this.warehouseLocation + "/nested_" + TestingNames.randomNameSuffix();
        String tableNameBob = "bob_external_table" + TestingNames.randomNameSuffix();
        String tableLocationBob = commonExternalLocationPath + "/bob_table";
        this.bobExecutor.executeQuery(String.format("CREATE TABLE %s (a bigint) WITH (external_location = '%s')", tableNameBob, tableLocationBob), new QueryExecutor.QueryParam[0]);
        String owner = this.hdfsClient.getOwner(tableLocationBob);
        Assertions.assertThat((String)owner).isEqualTo(this.configuredHdfsUser);
        String tableNameAlice = "alice_external_table" + TestingNames.randomNameSuffix();
        String tableLocationAlice = commonExternalLocationPath + "/alice_table";
        this.aliceExecutor.executeQuery(String.format("CREATE TABLE %s (a bigint) WITH (external_location = '%s')", tableNameAlice, tableLocationAlice), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)this.aliceExecutor.executeQuery(String.format("SELECT * FROM %s", tableNameAlice), new QueryExecutor.QueryParam[0]))).hasRowsCount(0);
        owner = this.hdfsClient.getOwner(tableLocationAlice);
        Assertions.assertThat((String)owner).isEqualTo(this.configuredHdfsUser);
        this.bobExecutor.executeQuery(String.format("DROP TABLE IF EXISTS %s", tableNameBob), new QueryExecutor.QueryParam[0]);
        this.aliceExecutor.executeQuery(String.format("DROP TABLE IF EXISTS %s", tableNameAlice), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hdfs_no_impersonation", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testHdfsImpersonationDisabled() {
        String tableName = "check_hdfs_impersonation_disabled";
        this.checkTableOwner(tableName, this.configuredHdfsUser, this.aliceExecutor);
    }

    @Test(groups={"hdfs_impersonation", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testHdfsImpersonationEnabled() {
        String tableName = "check_hdfs_impersonation_enabled";
        this.checkTableOwner(tableName, this.aliceJdbcUser, this.aliceExecutor);
        this.checkTableGroup(tableName, this.aliceExecutor);
    }

    private static String getTableLocation(QueryExecutor executor, String tableName) {
        String location = (String)Iterables.getOnlyElement((Iterable)executor.executeQuery(String.format("SELECT DISTINCT regexp_replace(\"$path\", '/[^/]*$', '') FROM %s", tableName), new QueryExecutor.QueryParam[0]).column(1));
        if (location.startsWith("hdfs://")) {
            return URI.create(location).getPath();
        }
        return location;
    }

    private void checkTableOwner(String tableName, String expectedOwner, QueryExecutor executor) {
        executor.executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        executor.executeQuery(String.format("CREATE TABLE %s AS SELECT 'abc' c", tableName), new QueryExecutor.QueryParam[0]);
        String tableLocation = TestImpersonation.getTableLocation(executor, tableName);
        String owner = this.hdfsClient.getOwner(tableLocation);
        Assertions.assertThat((String)owner).isEqualTo(expectedOwner);
        executor.executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    private void checkTableGroup(String tableName, QueryExecutor executor) {
        executor.executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        executor.executeQuery(String.format("CREATE TABLE %s AS SELECT 'abc' c", tableName), new QueryExecutor.QueryParam[0]);
        String tableLocation = TestImpersonation.getTableLocation(executor, tableName);
        String warehouseLocation = tableLocation.substring(0, tableLocation.lastIndexOf("/"));
        String warehouseLocationGroup = this.hdfsClient.getGroup(warehouseLocation);
        String tableLocationGroup = this.hdfsClient.getGroup(warehouseLocation);
        Assertions.assertThat((String)tableLocationGroup).isEqualTo(warehouseLocationGroup);
    }
}

