/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.cli;

import com.google.common.base.CharMatcher;
import io.trino.tempto.process.LocalCliProcess;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;

public final class TrinoCliProcess
extends LocalCliProcess {
    private static final Pattern TRINO_PROMPT_PATTERN = Pattern.compile("trino(:[a-z0-9_]+)?>");

    public TrinoCliProcess(Process process) {
        super(process);
    }

    public List<String> readLinesUntilPrompt() {
        ArrayList<String> lines = new ArrayList<String>();
        while (!this.hasNextOutput(TRINO_PROMPT_PATTERN)) {
            lines.add(CharMatcher.ascii().retainFrom((CharSequence)this.nextOutputLine()).trim());
        }
        this.waitForPrompt();
        return lines;
    }

    public void waitForPrompt() {
        Assertions.assertThat((String)this.nextOutputToken()).matches(TRINO_PROMPT_PATTERN);
    }
}

