/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import io.airlift.units.Duration;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.CachingTestUtils;
import io.trino.tests.product.utils.QueryAssertions;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestDeltaLakeAlluxioCaching
extends ProductTest {
    private String bucketName;

    @BeforeMethodWithContext
    public void setUp() {
        this.bucketName = Objects.requireNonNull(System.getenv("S3_BUCKET"), "Environment variable not set: S3_BUCKET");
    }

    @Test(groups={"delta-lake-alluxio-caching", "profile_specific_tests"})
    public void testReadFromCache() {
        this.testReadFromTable("table1");
        this.testReadFromTable("table2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReadFromTable(String tableNameSuffix) {
        String cachedSchemaName = "delta.test_caching";
        String nonCachedTableName = "delta_non_cached.test_caching.test_cache_read" + tableNameSuffix;
        try {
            QueryExecutors.onTrino().executeQuery("CREATE SCHEMA " + cachedSchemaName + " WITH (location = 's3://" + this.bucketName + "/test_delta_cached')", new QueryExecutor.QueryParam[0]);
            String cachedTableName = cachedSchemaName + ".test_cache_read" + tableNameSuffix;
            this.createTestTable(cachedTableName);
            CachingTestUtils.CacheStats beforeCacheStats = CachingTestUtils.getCacheStats("delta");
            long tableSize = (Long)QueryExecutors.onTrino().executeQuery("SELECT SUM(size) as size FROM (SELECT \"$path\", \"$file_size\" AS size FROM " + nonCachedTableName + " GROUP BY 1, 2)", new QueryExecutor.QueryParam[0]).getOnlyValue();
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + cachedTableName, new QueryExecutor.QueryParam[0]))).hasAnyRows();
            QueryAssertions.assertEventually(new Duration(20.0, TimeUnit.SECONDS), () -> {
                CachingTestUtils.CacheStats afterQueryCacheStats = CachingTestUtils.getCacheStats("delta");
                io.airlift.testing.Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(afterQueryCacheStats.cacheSpaceUsed()), (Comparable)Long.valueOf(beforeCacheStats.cacheSpaceUsed() + tableSize));
                io.airlift.testing.Assertions.assertGreaterThan((Comparable)Double.valueOf(afterQueryCacheStats.externalReads()), (Comparable)Double.valueOf(beforeCacheStats.externalReads()));
                io.airlift.testing.Assertions.assertGreaterThanOrEqual((Comparable)Double.valueOf(afterQueryCacheStats.cacheReads()), (Comparable)Double.valueOf(beforeCacheStats.cacheReads()));
            });
            QueryAssertions.assertEventually(new Duration(10.0, TimeUnit.SECONDS), () -> {
                CachingTestUtils.CacheStats beforeQueryCacheStats = CachingTestUtils.getCacheStats("delta");
                ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + cachedTableName, new QueryExecutor.QueryParam[0]))).hasAnyRows();
                CachingTestUtils.CacheStats afterQueryCacheStats = CachingTestUtils.getCacheStats("delta");
                io.airlift.testing.Assertions.assertGreaterThan((Comparable)Double.valueOf(afterQueryCacheStats.cacheReads()), (Comparable)Double.valueOf(beforeQueryCacheStats.cacheReads()));
                Assertions.assertThat((double)afterQueryCacheStats.externalReads()).isEqualTo(beforeQueryCacheStats.externalReads());
                Assertions.assertThat((long)afterQueryCacheStats.cacheSpaceUsed()).isEqualTo(beforeQueryCacheStats.cacheSpaceUsed());
            });
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + nonCachedTableName, new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DROP SCHEMA IF EXISTS " + cachedSchemaName, new QueryExecutor.QueryParam[0]);
        }
    }

    private void createTestTable(String tableName) {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("SET SESSION delta.target_max_file_size = '2MB'", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + tableName + " AS SELECT * FROM tpch.sf1.customer", new QueryExecutor.QueryParam[0]);
    }
}

