/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DatabricksVersion;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestDeltaLakeAlterTableCompatibility
extends BaseTestDeltaLakeS3Storage {
    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testAddColumnWithCommentOnTrino() {
        String tableName = "test_dl_add_column_with_comment_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (col INT) WITH (location = 's3://%s/%s')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN new_col INT COMMENT 'new column comment'", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "new_col")).isEqualTo("new column comment");
            Assertions.assertThat((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "new_col")).isEqualTo("new column comment");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testRenameColumn() {
        String tableName = "test_dl_rename_column_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col INT) USING DELTA LOCATION 's3://%s/%s' TBLPROPERTIES ('delta.columnMapping.mode'='name')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1)", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT col FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " RENAME COLUMN col TO new_col", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT new_col FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (2)", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT new_col FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testRenamePartitionedColumn() {
        String tableName = "test_dl_rename_partitioned_column_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col INT, part STRING) USING DELTA LOCATION 's3://%s/%s' PARTITIONED BY (part) TBLPROPERTIES ('delta.columnMapping.mode'='name')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 'part1')", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT col, part FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "part1"})});
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " RENAME COLUMN part TO new_part", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT col, new_part FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "part1"})});
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (2, 'part2')", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT col, new_part FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "part1"}), QueryAssert.Row.row((Object[])new Object[]{2, "part2"})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testDropNotNullConstraint() {
        this.testDropNotNullConstraint("id");
        this.testDropNotNullConstraint("name");
        this.testDropNotNullConstraint("none");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDropNotNullConstraint(String columnMappingMode) {
        String tableName = "test_dl_drop_not_null_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(data1 int NOT NULL, data2 int NOT NULL, part1 int NOT NULL, part2 int NOT NULL) USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'PARTITIONED BY (part1, part2)TBLPROPERTIES ('delta.columnMapping.mode'='" + columnMappingMode + "')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " ALTER COLUMN data1 DROP NOT NULL", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " ALTER COLUMN part1 DROP NOT NULL", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ALTER COLUMN data2 DROP NOT NULL", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ALTER COLUMN part2 DROP NOT NULL", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (NULL, NULL, NULL, NULL)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (NULL, NULL, NULL, NULL)", new QueryExecutor.QueryParam[0]);
            ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null, null}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expected);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expected);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testCommentOnTable() {
        String tableName = "test_dl_comment_table_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (col INT) WITH (location = 's3://%s/%s')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON TABLE delta.default." + tableName + " IS 'test comment'", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat((String)DeltaLakeTestUtils.getTableCommentOnTrino("default", tableName)).isEqualTo("test comment");
            Assertions.assertThat((String)DeltaLakeTestUtils.getTableCommentOnDelta("default", tableName)).isEqualTo("test comment");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testCommentOnColumn() {
        String tableName = "test_dl_comment_column_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (col INT) WITH (location = 's3://%s/%s')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".col IS 'test column comment'", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "col")).isEqualTo("test column comment");
            Assertions.assertThat((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "col")).isEqualTo("test column comment");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testTrinoPreservesReaderAndWriterVersions() {
        String tableName = "test_trino_preserves_versions_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col int) USING DELTA LOCATION 's3://%s/%s'TBLPROPERTIES ('delta.minReaderVersion'='1', 'delta.minWriterVersion'='1', 'delta.checkpointInterval' = 1)", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".col IS 'test column comment'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("COMMENT ON TABLE delta.default." + tableName + " IS 'test table comment'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN new_col INT", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (1, 1)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("UPDATE delta.default." + tableName + " SET col = 2", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("MERGE INTO delta.default." + tableName + " t USING delta.default." + tableName + " s ON (t.col = s.col) WHEN MATCHED THEN UPDATE SET new_col = 3", new QueryExecutor.QueryParam[0]);
            List minReaderVersion = (List)Iterables.getOnlyElement((Iterable)QueryExecutors.onDelta().executeQuery("SHOW TBLPROPERTIES " + tableName + "(delta.minReaderVersion)", new QueryExecutor.QueryParam[0]).rows());
            Assertions.assertThat((String)((String)minReaderVersion.get(1))).isEqualTo("1");
            List minWriterVersion = (List)Iterables.getOnlyElement((Iterable)QueryExecutors.onDelta().executeQuery("SHOW TBLPROPERTIES " + tableName + "(delta.minWriterVersion)", new QueryExecutor.QueryParam[0]).rows());
            Assertions.assertThat((String)((String)minWriterVersion.get(1))).isEqualTo("1");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-exclude-91", "delta-lake-oss", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testTrinoPreservesTableFeature() {
        String tableName = "test_trino_preserves_table_feature_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (col int)USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'TBLPROPERTIES ('delta.checkpointInterval'=1, 'delta.feature.columnMapping'='supported')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".col IS 'test column comment'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("COMMENT ON TABLE delta.default." + tableName + " IS 'test table comment'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN new_col INT", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (1, 1)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("UPDATE delta.default." + tableName + " SET col = 2", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("MERGE INTO delta.default." + tableName + " t USING delta.default." + tableName + " s ON (t.col = s.col) WHEN MATCHED THEN UPDATE SET new_col = 3", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat((String)DeltaLakeTestUtils.getTablePropertyOnDelta("default", tableName, "delta.feature.columnMapping")).isEqualTo("supported");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testTrinoAlterTablePreservesGeneratedColumn() {
        String tableName = "test_trino_alter_table_preserves_generated_column_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (a INT, b INT GENERATED ALWAYS AS (a * 2))\nUSING DELTA LOCATION 's3://%s/%s'\n", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".b IS 'test column comment'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("COMMENT ON TABLE delta.default." + tableName + " IS 'test table comment'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN c INT", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat((String)((String)QueryExecutors.onDelta().executeQuery("SHOW CREATE TABLE default." + tableName, new QueryExecutor.QueryParam[0]).getOnlyValue())).contains(new CharSequence[]{(DeltaLakeTestUtils.getDatabricksRuntimeVersion().orElseThrow().equals(DatabricksVersion.DATABRICKS_91_RUNTIME_VERSION) ? "`b`" : "b") + " INT GENERATED ALWAYS AS ( a * 2 )"});
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " (a, c) VALUES (1, 3)", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 2, 3})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT column_name, extra_info FROM delta.information_schema.columns WHERE table_schema = 'default' AND table_name = '" + tableName + "'", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a", null}), QueryAssert.Row.row((Object[])new Object[]{"b", "generated: a * 2"}), QueryAssert.Row.row((Object[])new Object[]{"c", null})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("DESCRIBE delta.default." + tableName, new QueryExecutor.QueryParam[0]).project(new int[]{1, 3}))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a", ""}), QueryAssert.Row.row((Object[])new Object[]{"b", "generated: a * 2"}), QueryAssert.Row.row((Object[])new Object[]{"c", ""})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW COLUMNS FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]).project(new int[]{1, 3}))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a", ""}), QueryAssert.Row.row((Object[])new Object[]{"b", "generated: a * 2"}), QueryAssert.Row.row((Object[])new Object[]{"c", ""})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testTypeWideningInteger() {
        String tableName = "test_dl_type_widening_integer_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(a byte, b byte) USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'TBLPROPERTIES ('delta.enableTypeWidening'=true)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (127, -128)", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{127, -128})});
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " CHANGE COLUMN a TYPE short", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{127, -128})});
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " (a) VALUES 32767", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{127, -128}), QueryAssert.Row.row((Object[])new Object[]{Short.MAX_VALUE, null})});
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " CHANGE COLUMN b TYPE integer", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{127, -128}), QueryAssert.Row.row((Object[])new Object[]{Short.MAX_VALUE, null})});
            QueryExecutors.onDelta().executeQuery("UPDATE default." + tableName + " SET b = -32768 WHERE b IS NULL", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{127, -128}), QueryAssert.Row.row((Object[])new Object[]{Short.MAX_VALUE, Short.MIN_VALUE})});
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " CHANGE COLUMN a TYPE integer", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{127, -128}), QueryAssert.Row.row((Object[])new Object[]{Short.MAX_VALUE, Short.MIN_VALUE})});
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " (a) VALUES 2147483647", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{127, -128}), QueryAssert.Row.row((Object[])new Object[]{Short.MAX_VALUE, Short.MIN_VALUE}), QueryAssert.Row.row((Object[])new Object[]{Integer.MAX_VALUE, null})});
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " CHANGE COLUMN a TYPE long", new QueryExecutor.QueryParam[0])).hasMessageContaining("ALTER TABLE CHANGE COLUMN is not supported for changing column a from INT to BIGINT");
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }
}

