/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tests.product.BaseTestTableFormats;
import java.util.Objects;
import org.testng.annotations.Test;

public class TestDeltaLakeAzure
extends BaseTestTableFormats {
    @Inject
    @Named(value="databases.presto.abfs_schema")
    private String schema;
    private String schemaLocation;

    @BeforeMethodWithContext
    public void setUp() {
        String container = Objects.requireNonNull(System.getenv("ABFS_CONTAINER"), "Environment variable not set: ABFS_CONTAINER");
        String account = Objects.requireNonNull(System.getenv("ABFS_ACCOUNT"), "Environment variable not set: ABFS_ACCOUNT");
        this.schemaLocation = String.format("abfs://%s@%s.dfs.core.windows.net/%s", container, account, this.schema);
    }

    @Override
    protected String getCatalogName() {
        return "delta";
    }

    @Test(groups={"delta-lake-azure", "profile_specific_tests"})
    public void testCreateAndSelectNationTable() {
        super.testCreateAndSelectNationTable(this.schemaLocation);
    }

    @Test(groups={"delta-lake-azure", "profile_specific_tests"})
    public void testBasicWriteOperations() {
        super.testBasicWriteOperations(this.schemaLocation);
    }

    @Test(groups={"delta-lake-azure", "profile_specific_tests"})
    public void testPathContainsSpecialCharacter() {
        super.testPathContainsSpecialCharacter(this.schemaLocation, "partitioned_by");
    }
}

