/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestDeltaLakeCaseInsensitiveMapping
extends BaseTestDeltaLakeS3Storage {
    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testNonLowercaseColumnNames() {
        String tableName = "test_dl_non_lowercase_column" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(UPPER_CASE_INT INT, Camel_Case_String STRING, PART INT)USING delta PARTITIONED BY (PART)LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 'a', 10)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (2, 'ab', 20)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (null, null, null)", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"upper_case_int", null, 1.0, 0.33333333333, null, "1", "2"}), QueryAssert.Row.row((Object[])new Object[]{"camel_case_string", 2.0, 1.0, 0.33333333333, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"part", null, 2.0, 0.33333333333, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-databricks-104", "delta-lake-databricks-113", "delta-lake-databricks-122", "delta-lake-oss", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testNonLowercaseFieldNames() {
        String tableName = "test_dl_non_lowercase_field" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(id int, UPPER_CASE STRUCT<UPPER_FIELD: string>, Mixed_Case struct<Mixed_Nested: struct<Mixed_Field: string>>)USING delta LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " SELECT 1, row('test uppercase'), row(row('test mixedcase'))", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"id", null, 1.0, 0.0, null, "1", "1"}), QueryAssert.Row.row((Object[])new Object[]{"upper_case", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"mixed_case", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 1.0, null, null})});
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "test uppercase", "test mixedcase"}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT id, upper_case.upper_field, mixed_case.mixed_nested.mixed_field FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT id, upper_case.upper_field, mixed_case.mixed_nested.mixed_field FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT id FROM delta.default." + tableName + " WHERE upper_case.upper_field = 'test uppercase'", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT id FROM delta.default." + tableName + " WHERE mixed_case.mixed_nested.mixed_field = 'test mixedcase'", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testColumnCommentWithNonLowerCaseColumnName() {
        String tableName = "test_dl_column_comment_uppercase_name" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(UPPER_CASE INT COMMENT 'test column comment')USING delta LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            Assertions.assertThat((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "upper_case")).isEqualTo("test column comment");
            Assertions.assertThat((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "UPPER_CASE")).isEqualTo("test column comment");
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".upper_case IS 'test updated comment'", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "upper_case")).isEqualTo("test updated comment");
            Assertions.assertThat((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "UPPER_CASE")).isEqualTo("test updated comment");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testNotNullColumnWithNonLowerCaseColumnName() {
        String tableName = "test_dl_notnull_column_uppercase_name" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(UPPER_CASE INT NOT NULL)USING delta LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".upper_case IS 'test comment'", new QueryExecutor.QueryParam[0]);
            Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES NULL", new QueryExecutor.QueryParam[0])).hasMessageContaining("NULL value not allowed for NOT NULL column");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testGeneratedColumnWithNonLowerCaseColumnName() {
        String tableName = "test_dl_generated_column_uppercase_name" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(A INT, B INT GENERATED ALWAYS AS (A * 2))USING delta LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".a IS 'test comment for a'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".b IS 'test comment for b'", new QueryExecutor.QueryParam[0]);
            Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (1, 2)", new QueryExecutor.QueryParam[0])).hasMessageContaining("Writing to tables with generated columns is not supported");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-exclude-91", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testIdentityColumnWithNonLowerCaseColumnName() {
        String tableName = "test_identity_column_case_sensitivity_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(data INT, UPPERCASE_IDENTITY BIGINT GENERATED ALWAYS AS IDENTITY)USING DELTA LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'TBLPROPERTIES ('delta.columnMapping.mode'='name')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " (data) VALUES (1), (2), (3)", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 1}), QueryAssert.Row.row((Object[])new Object[]{2, 2}), QueryAssert.Row.row((Object[])new Object[]{3, 3})});
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (4, 4)", new QueryExecutor.QueryParam[0])).hasMessageContaining("Writing to tables with identity columns is not supported");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("UPDATE delta.default." + tableName + " SET data = 3", new QueryExecutor.QueryParam[0])).hasMessageContaining("Writing to tables with identity columns is not supported");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageContaining("Writing to tables with identity columns is not supported");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("MERGE INTO delta.default." + tableName + " t USING delta.default." + tableName + " s ON (t.data = s.data) WHEN MATCHED THEN UPDATE SET data = 1", new QueryExecutor.QueryParam[0])).hasMessageContaining("Writing to tables with identity columns is not supported");
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN new_col integer", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " RENAME COLUMN new_col TO renamed_col", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".uppercase_identity IS 'test comment'", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " DROP COLUMN renamed_col", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat((String)((String)QueryExecutors.onDelta().executeQuery("SHOW CREATE TABLE default." + tableName, new QueryExecutor.QueryParam[0]).getOnlyValue())).contains(new CharSequence[]{"UPPERCASE_IDENTITY BIGINT GENERATED ALWAYS AS IDENTITY"});
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " RENAME COLUMN uppercase_identity TO renamed_identity", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat((String)((String)QueryExecutors.onDelta().executeQuery("SHOW CREATE TABLE default." + tableName, new QueryExecutor.QueryParam[0]).getOnlyValue())).contains(new CharSequence[]{"renamed_identity BIGINT GENERATED ALWAYS AS IDENTITY"});
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }
}

