/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.amazonaws.services.s3.AmazonS3;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.S3ClientFactory;
import io.trino.tests.product.deltalake.TransactionLogAssertions;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestDeltaLakeCreateOrReplaceTableAsSelectCompatibility
extends BaseTestDeltaLakeS3Storage {
    @Inject
    @Named(value="s3.server_type")
    private String s3ServerType;
    private AmazonS3 s3;

    @BeforeMethodWithContext
    public void setup() {
        super.setUp();
        this.s3 = new S3ClientFactory().createS3Client(this.s3ServerType);
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testCreateOrReplaceTableOnDeltaWithSchemaChange() {
        String tableName = "test_replace_table_with_schema_change_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default." + tableName + " (ts VARCHAR) with (location = 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "', checkpoint_interval = 10)", new QueryExecutor.QueryParam[0]);
        try {
            List<QueryAssert.Row> expectedRows = TestDeltaLakeCreateOrReplaceTableAsSelectCompatibility.performInsert(QueryExecutors.onDelta(), tableName, 12);
            TransactionLogAssertions.assertTransactionLogVersion(this.s3, this.bucketName, tableName, 12);
            QueryExecutors.onDelta().executeQuery("CREATE OR REPLACE TABLE " + tableName + " USING DELTA AS SELECT CAST(ts AS TIMESTAMP) FROM " + tableName, new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT to_iso8601(ts) FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(expectedRows);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry(tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testCreateOrReplaceTableOnTrinoWithSchemaChange() {
        String tableName = "test_replace_table_with_schema_change_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default." + tableName + " (ts VARCHAR) with (location = 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "', checkpoint_interval = 10)", new QueryExecutor.QueryParam[0]);
        try {
            List<QueryAssert.Row> expectedRows = TestDeltaLakeCreateOrReplaceTableAsSelectCompatibility.performInsert(QueryExecutors.onDelta(), tableName, 12);
            TransactionLogAssertions.assertTransactionLogVersion(this.s3, this.bucketName, tableName, 12);
            QueryExecutors.onTrino().executeQuery("CREATE OR REPLACE TABLE delta.default." + tableName + " AS SELECT CAST(ts AS TIMESTAMP(6)) as ts FROM " + tableName, new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT date_format(ts, \"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'\") FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly(expectedRows);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry(tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testCreateOrReplaceTableWithSchemaChangeOnCheckpoint() {
        String tableName = "test_replace_table_with_schema_change_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default." + tableName + " (ts VARCHAR) with (location = 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "', checkpoint_interval = 10)", new QueryExecutor.QueryParam[0]);
        try {
            ImmutableList.Builder expected = ImmutableList.builder();
            expected.addAll(TestDeltaLakeCreateOrReplaceTableAsSelectCompatibility.performInsert(QueryExecutors.onDelta(), tableName, 9));
            QueryExecutors.onDelta().executeQuery("CREATE OR REPLACE TABLE " + tableName + " USING DELTA AS SELECT CAST(ts AS TIMESTAMP) FROM " + tableName, new QueryExecutor.QueryParam[0]);
            TransactionLogAssertions.assertLastEntryIsCheckpointed(this.s3, this.bucketName, tableName);
            QueryExecutors.onDelta().executeQuery("INSERT INTO " + tableName + " VALUES \"1960-01-01 01:02:03\", \"1961-01-01 01:02:03\", \"1962-01-01 01:02:03\"", new QueryExecutor.QueryParam[0]);
            expected.add((Object[])new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1960-01-01T01:02:03.000Z"}), QueryAssert.Row.row((Object[])new Object[]{"1961-01-01T01:02:03.000Z"}), QueryAssert.Row.row((Object[])new Object[]{"1962-01-01T01:02:03.000Z"})});
            TransactionLogAssertions.assertTransactionLogVersion(this.s3, this.bucketName, tableName, 11);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT to_iso8601(ts) FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expected.build());
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry(tableName);
        }
    }

    private static List<QueryAssert.Row> performInsert(QueryExecutor queryExecutor, String tableName, int numberOfRows) {
        ImmutableList.Builder expectedRowBuilder = ImmutableList.builder();
        for (int i = 0; i < numberOfRows; ++i) {
            queryExecutor.executeQuery("INSERT INTO " + tableName + " VALUES \"1960-01-01 01:02:03\", \"1961-01-01 01:02:03\", \"1962-01-01 01:02:03\"", new QueryExecutor.QueryParam[0]);
            expectedRowBuilder.add((Object[])new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1960-01-01T01:02:03.000Z"}), QueryAssert.Row.row((Object[])new Object[]{"1961-01-01T01:02:03.000Z"}), QueryAssert.Row.row((Object[])new Object[]{"1962-01-01T01:02:03.000Z"})});
        }
        return expectedRowBuilder.build();
    }
}

