/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DatabricksVersion;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestDeltaLakeDatabricksCreateTableCompatibility
extends BaseTestDeltaLakeS3Storage {
    private DatabricksVersion databricksRuntimeVersion;

    @BeforeMethodWithContext
    public void setup() {
        this.databricksRuntimeVersion = DeltaLakeTestUtils.getDatabricksRuntimeVersion().orElseThrow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testDatabricksCanReadInitialCreateTable() {
        String tableName = "test_dl_create_table_compat_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (integer int, string varchar, timetz timestamp with time zone) with (location = 's3://%s/%s')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SHOW TABLES FROM default LIKE '" + tableName + "'", new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"default", tableName, false})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT count(*) FROM default." + tableName, new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0})});
            String showCreateTable = this.databricksRuntimeVersion.isAtLeast(DatabricksVersion.DATABRICKS_104_RUNTIME_VERSION) ? String.format("CREATE TABLE spark_catalog.default.%s (\n  integer INT,\n  string STRING,\n  timetz TIMESTAMP)\nUSING delta\nLOCATION 's3://%s/%s'\n%s", tableName, this.bucketName, tableDirectory, this.getDatabricksDefaultTableProperties()) : String.format("CREATE TABLE `default`.`%s` (\n  `integer` INT,\n  `string` STRING,\n  `timetz` TIMESTAMP)\nUSING DELTA\nLOCATION 's3://%s/%s'\nTBLPROPERTIES (\n  'delta.enableDeletionVectors' = 'false')\n", tableName, this.bucketName, tableDirectory);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SHOW CREATE TABLE default." + tableName, new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{showCreateTable})});
            this.testInsert(tableName, (List<QueryAssert.Row>)ImmutableList.of());
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testDatabricksCanReadInitialCreatePartitionedTable() {
        String tableName = "test_dl_create_table_compat_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (integer int, string varchar, timetz timestamp with time zone) with (location = 's3://%s/%s', partitioned_by = ARRAY['string'])", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SHOW TABLES LIKE '" + tableName + "'", new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"default", tableName, false})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT count(*) FROM " + tableName, new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0})});
            String showCreateTable = this.databricksRuntimeVersion.isAtLeast(DatabricksVersion.DATABRICKS_104_RUNTIME_VERSION) ? String.format("CREATE TABLE spark_catalog.default.%s (\n  integer INT,\n  string STRING,\n  timetz TIMESTAMP)\nUSING delta\nPARTITIONED BY (string)\nLOCATION 's3://%s/%s'\n%s", tableName, this.bucketName, tableDirectory, this.getDatabricksDefaultTableProperties()) : String.format("CREATE TABLE `default`.`%s` (\n  `integer` INT,\n  `string` STRING,\n  `timetz` TIMESTAMP)\nUSING DELTA\nPARTITIONED BY (string)\nLOCATION 's3://%s/%s'\nTBLPROPERTIES (\n  'delta.enableDeletionVectors' = 'false')\n", tableName, this.bucketName, tableDirectory);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SHOW CREATE TABLE " + tableName, new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{showCreateTable})});
            this.testInsert(tableName, (List<QueryAssert.Row>)ImmutableList.of());
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testDatabricksCanReadInitialCreateTableAs() {
        String tableName = "test_dl_create_table_as_compat_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (integer, string, timetz) with (location = 's3://%s/%s') AS VALUES (4, 'four', TIMESTAMP '2020-01-01 01:00:00.000 UTC'), (5, 'five', TIMESTAMP '2025-01-01 01:00:00.000 UTC'), (null, null, null)", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SHOW TABLES FROM default LIKE '" + tableName + "'", new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"default", tableName, false})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT count(*) FROM default." + tableName, new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3})});
            String showCreateTable = this.databricksRuntimeVersion.isAtLeast(DatabricksVersion.DATABRICKS_104_RUNTIME_VERSION) ? String.format("CREATE TABLE spark_catalog.default.%s (\n  integer INT,\n  string STRING,\n  timetz TIMESTAMP)\nUSING delta\nLOCATION 's3://%s/%s'\n%s", tableName, this.bucketName, tableDirectory, this.getDatabricksDefaultTableProperties()) : String.format("CREATE TABLE `default`.`%s` (\n  `integer` INT,\n  `string` STRING,\n  `timetz` TIMESTAMP)\nUSING DELTA\nLOCATION 's3://%s/%s'\nTBLPROPERTIES (\n  'delta.enableDeletionVectors' = 'false')\n", tableName, this.bucketName, tableDirectory);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SHOW CREATE TABLE default." + tableName, new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{showCreateTable})});
            this.testInsert(tableName, (List<QueryAssert.Row>)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{4, "four", "2020-01-01T01:00:00.000Z"}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, "five", "2025-01-01T01:00:00.000Z"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null})));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testDatabricksCanReadInitialCreatePartitionedTableAs() {
        String tableName = "test_dl_create_table_compat_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (integer, string, timetz) with (location = 's3://%s/%s', partitioned_by = ARRAY['string']) AS VALUES (4, 'four', TIMESTAMP '2020-01-01 01:00:00.000 UTC'), (5, 'five', TIMESTAMP '2025-01-01 01:00:00.000 UTC'), (null, null, null)", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SHOW TABLES LIKE '" + tableName + "'", new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"default", tableName, false})});
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT count(*) FROM " + tableName, new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3})});
            String showCreateTable = this.databricksRuntimeVersion.isAtLeast(DatabricksVersion.DATABRICKS_104_RUNTIME_VERSION) ? String.format("CREATE TABLE spark_catalog.default.%s (\n  integer INT,\n  string STRING,\n  timetz TIMESTAMP)\nUSING delta\nPARTITIONED BY (string)\nLOCATION 's3://%s/%s'\n%s", tableName, this.bucketName, tableDirectory, this.getDatabricksDefaultTableProperties()) : String.format("CREATE TABLE `default`.`%s` (\n  `integer` INT,\n  `string` STRING,\n  `timetz` TIMESTAMP)\nUSING DELTA\nPARTITIONED BY (string)\nLOCATION 's3://%s/%s'\nTBLPROPERTIES (\n  'delta.enableDeletionVectors' = 'false')\n", tableName, this.bucketName, tableDirectory);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SHOW CREATE TABLE " + tableName, new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{showCreateTable})});
            this.testInsert(tableName, (List<QueryAssert.Row>)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{4, "four", "2020-01-01T01:00:00.000Z"}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, "five", "2025-01-01T01:00:00.000Z"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null})));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    private void testInsert(String tableName, List<QueryAssert.Row> existingRows) {
        QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 'one', TIMESTAMP '2960-10-31 01:00:00')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (2, 'two', TIMESTAMP '2020-10-31 01:00:00')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (3, 'three', TIMESTAMP '1900-10-31 01:00:00')", new QueryExecutor.QueryParam[0]);
        ImmutableList.Builder expected = ImmutableList.builder();
        expected.addAll(existingRows);
        expected.add((Object)QueryAssert.Row.row((Object[])new Object[]{1, "one", "2960-10-31T01:00:00.000Z"}));
        expected.add((Object)QueryAssert.Row.row((Object[])new Object[]{2, "two", "2020-10-31T01:00:00.000Z"}));
        expected.add((Object)QueryAssert.Row.row((Object[])new Object[]{3, "three", "1900-10-31T01:00:00.000Z"}));
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT integer, string, to_iso8601(timetz) FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expected.build());
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testCreateTableWithTableComment() {
        String tableName = "test_dl_create_table_comment_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (col INT) COMMENT 'test comment' WITH (location = 's3://%s/%s')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            Assertions.assertThat((String)DeltaLakeTestUtils.getTableCommentOnTrino("default", tableName)).isEqualTo("test comment");
            Assertions.assertThat((String)DeltaLakeTestUtils.getTableCommentOnDelta("default", tableName)).isEqualTo("test comment");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testCreateTableWithColumnCommentOnTrino() {
        String tableName = "test_dl_create_column_comment_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (col INT COMMENT 'test comment') WITH (location = 's3://%s/%s')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            Assertions.assertThat((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "col")).isEqualTo("test comment");
            Assertions.assertThat((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "col")).isEqualTo("test comment");
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN new_col INT", new QueryExecutor.QueryParam[0]);
            Assertions.assertThat((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "col")).isEqualTo("test comment");
            Assertions.assertThat((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "col")).isEqualTo("test comment");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testCreateTableWithColumnCommentOnDelta() {
        String tableName = "test_dl_create_column_comment_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col INT COMMENT 'test comment') USING DELTA LOCATION 's3://%s/%s'", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            Assertions.assertThat((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "col")).isEqualTo("test comment");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testCreateTableWithDuplicatedColumnNames() {
        String tableName = "test_dl_create_table_with_duplicated_column_names_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        try {
            Assertions.assertThatThrownBy(() -> QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (col INT, COL int) USING DELTA LOCATION 's3://" + this.bucketName + "/" + tableDirectory + "'", new QueryExecutor.QueryParam[0])).hasMessageMatching("(?s).*(Found duplicate column|The column `col` already exists).*");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testCreateTableWithUnsupportedPartitionType() {
        String tableName = "test_dl_create_table_with_unsupported_column_types_" + TestingNames.randomNameSuffix();
        String tableLocation = "s3://%s/databricks-compatibility-test-%s".formatted(this.bucketName, tableName);
        try {
            Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default." + tableName + "(a INT, part ARRAY(INT)) WITH (partitioned_by = ARRAY['part'], location = '" + tableLocation + "')", new QueryExecutor.QueryParam[0])).hasMessageContaining("Using array, map or row type on partitioned columns is unsupported");
            Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default." + tableName + "(a INT, part MAP(INT,INT)) WITH (partitioned_by = ARRAY['part'], location = '" + tableLocation + "')", new QueryExecutor.QueryParam[0])).hasMessageContaining("Using array, map or row type on partitioned columns is unsupported");
            Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default." + tableName + "(a INT, part ROW(field INT)) WITH (partitioned_by = ARRAY['part'], location = '" + tableLocation + "')", new QueryExecutor.QueryParam[0])).hasMessageContaining("Using array, map or row type on partitioned columns is unsupported");
            Assertions.assertThatThrownBy(() -> QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(a INT, part ARRAY<INT>) USING DELTA PARTITIONED BY (part) LOCATION '" + tableLocation + "'", new QueryExecutor.QueryParam[0])).hasMessageMatching("(?s).*(Cannot use .* for partition column|Using column part of type .* as a partition column is not supported).*");
            Assertions.assertThatThrownBy(() -> QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(a INT, part MAP<INT,INT>) USING DELTA PARTITIONED BY (part) LOCATION '" + tableLocation + "'", new QueryExecutor.QueryParam[0])).hasMessageMatching("(?s).*(Cannot use .* for partition column|Using column part of type .* as a partition column is not supported).*");
            Assertions.assertThatThrownBy(() -> QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(a INT, part STRUCT<field: INT>) USING DELTA PARTITIONED BY (part) LOCATION '" + tableLocation + "'", new QueryExecutor.QueryParam[0])).hasMessageMatching("(?s).*(Cannot use .* for partition column|Using column part of type .* as a partition column is not supported).*");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testCreateTableWithAllPartitionColumns() {
        String tableName = "test_dl_create_table_with_all_partition_columns_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        try {
            Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default." + tableName + "(part int)WITH (partitioned_by = ARRAY['part'], location = 's3://" + this.bucketName + "/" + tableDirectory + "')", new QueryExecutor.QueryParam[0])).hasMessageContaining("Using all columns for partition columns is unsupported");
            Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default." + tableName + "(part int, another_part int)WITH (partitioned_by = ARRAY['part', 'another_part'], location = 's3://" + this.bucketName + "/" + tableDirectory + "')", new QueryExecutor.QueryParam[0])).hasMessageContaining("Using all columns for partition columns is unsupported");
            Assertions.assertThatThrownBy(() -> QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(part int)USING DELTA PARTITIONED BY (part)LOCATION 's3://" + this.bucketName + "/" + tableDirectory + "'", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot use all columns for partition columns");
            Assertions.assertThatThrownBy(() -> QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(part int, another_part int)USING DELTA PARTITIONED BY (part, another_part)LOCATION 's3://" + this.bucketName + "/" + tableDirectory + "'", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot use all columns for partition columns");
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    private String getDatabricksDefaultTableProperties() {
        if (this.databricksRuntimeVersion.isAtLeast(DatabricksVersion.DATABRICKS_113_RUNTIME_VERSION)) {
            return "TBLPROPERTIES (\n  'delta.enableDeletionVectors' = 'false',\n  'delta.minReaderVersion' = '1',\n  'delta.minWriterVersion' = '2')\n";
        }
        throw new IllegalArgumentException("Unsupported databricks runtime version: " + String.valueOf(this.databricksRuntimeVersion));
    }
}

