/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestDeltaLakeSystemTableCompatibility
extends BaseTestDeltaLakeS3Storage {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-exclude-91", "delta-lake-oss", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testTablePropertiesCaseSensitivity() {
        String tableName = "test_dl_table_properties_case_sensitivity_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col INT) USING DELTA LOCATION 's3://%s/%s' TBLPROPERTIES ('test_key'='test_value', 'Test_Key'='Test_Mixed_Case')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"test_key", "test_value"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"Test_Key", "Test_Mixed_Case"}));
        try {
            QueryResult deltaResult = QueryExecutors.onDelta().executeQuery("SHOW TBLPROPERTIES default." + tableName, new QueryExecutor.QueryParam[0]);
            QueryResult trinoResult = QueryExecutors.onTrino().executeQuery("SELECT * FROM default.\"" + tableName + "$properties\"", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)deltaResult)).contains((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)trinoResult)).contains((List)expectedRows);
            Assertions.assertThat((List)trinoResult.rows()).containsExactlyInAnyOrderElementsOf((Iterable)deltaResult.rows());
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testTablePropertiesWithTableFeatures() {
        String tableName = "test_dl_table_properties_with_features_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col INT) USING DELTA LOCATION 's3://%s/%s' TBLPROPERTIES ('delta.minReaderVersion'='3', 'delta.minWriterVersion'='7', 'delta.columnMapping.mode'='id')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"delta.columnMapping.mode", "id"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"delta.feature.columnMapping", "supported"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"delta.minReaderVersion", "3"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"delta.minWriterVersion", "7"}));
        try {
            QueryResult deltaResult = QueryExecutors.onDelta().executeQuery("SHOW TBLPROPERTIES default." + tableName, new QueryExecutor.QueryParam[0]);
            QueryResult trinoResult = QueryExecutors.onTrino().executeQuery("SELECT * FROM default.\"" + tableName + "$properties\"", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)deltaResult)).contains((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)trinoResult)).contains((List)expectedRows);
            Assertions.assertThat((List)trinoResult.rows()).containsExactlyInAnyOrderElementsOf((Iterable)deltaResult.rows());
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testTablePartitionsWithDeletionVectors() {
        String tableName = "test_table_partitions_with_deletion_vectors_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(a INT, b INT, c VARCHAR(10)) USING delta PARTITIONED BY (a, c) LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ('delta.enableDeletionVectors' = true)", new QueryExecutor.QueryParam[0]);
        ImmutableList expectedBeforeDelete = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"{\"a\":1,\"c\":\"varchar_1\"}", 3L, 1347L, "{\"b\":{\"min\":11,\"max\":19,\"null_count\":0}}"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"{\"a\":1,\"c\":\"varchar_2\"}", 1L, 449L, "{\"b\":{\"min\":13,\"max\":13,\"null_count\":0}}"}));
        ImmutableList expectedAfterFirstDelete = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"{\"a\":1,\"c\":\"varchar_1\"}", 2L, 898L, "{\"b\":{\"min\":11,\"max\":17,\"null_count\":0}}"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"{\"a\":1,\"c\":\"varchar_2\"}", 1L, 449L, "{\"b\":{\"min\":13,\"max\":13,\"null_count\":0}}"}));
        ImmutableList expectedAfterSecondDelete = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"{\"a\":1,\"c\":\"varchar_1\"}", 2L, 898L, "{\"b\":{\"min\":11,\"max\":17,\"null_count\":0}}"}));
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 11, 'varchar_1'), (1, 19, 'varchar_1'), (1, 17, 'varchar_1'), (1, 13, 'varchar_2')", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT cast(partition as json), file_count, total_size, cast(data as json) FROM delta.default.\"%s$partitions\"", tableName), new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedBeforeDelete);
            QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName + " WHERE b = 19", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT cast(partition as json), file_count, total_size, cast(data as json) FROM delta.default.\"%s$partitions\"", tableName), new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedAfterFirstDelete);
            QueryExecutors.onDelta().executeQuery("DELETE FROM default." + tableName + " WHERE c = 'varchar_2'", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT cast(partition as json), file_count, total_size, cast(data as json) FROM delta.default.\"%s$partitions\"", tableName), new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedAfterSecondDelete);
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE IF EXISTS default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testTablePartitionsWithNoColumnStats() {
        String tableName = "test_table_partitions_with_no_column_stats_" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "(a INT, b INT, c VARCHAR(10)) USING delta PARTITIONED BY (a, c) LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ('delta.dataSkippingNumIndexedCols' = 0)", new QueryExecutor.QueryParam[0]);
        ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"{\"a\":1,\"c\":\"varchar_1\"}", 3L, 1347L, "{\"b\":{\"min\":null,\"max\":null,\"null_count\":null}}"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"{\"a\":1,\"c\":\"varchar_2\"}", 1L, 449L, "{\"b\":{\"min\":null,\"max\":null,\"null_count\":null}}"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"{\"a\":1,\"c\":\"varchar_3\"}", 1L, 413L, "{\"b\":{\"min\":null,\"max\":null,\"null_count\":null}}"}));
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 11, 'varchar_1'), (1, 19, 'varchar_1'), (1, 17, 'varchar_1'), (1, 13, 'varchar_2'), (1, NULL, 'varchar_3')", new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT cast(partition as json), file_count, total_size, cast(data as json) FROM delta.default.\"%s$partitions\"", tableName), new QueryExecutor.QueryParam[0]))).containsOnly((List)expected);
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE IF EXISTS default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }
}

