/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestDeltaLakeTimeTravelCompatibility
extends BaseTestDeltaLakeS3Storage {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testReadFromTableRestoredToPreviousVersion() {
        String tableName = "test_dl_time_travel_restore_" + TestingNames.randomNameSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (a_integer integer) WITH (location = 's3://%s/%s')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES 1", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES 2", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES 3", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("UPDATE delta.default." + tableName + " SET a_integer = a_integer + 10 WHERE a_integer > 1", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DELETE FROM delta.default." + tableName + " WHERE a_integer < 10", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN a_varchar varchar", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("UPDATE delta.default." + tableName + " SET a_varchar = 'foo'", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{12, "foo"}), (Object)QueryAssert.Row.row((Object[])new Object[]{13, "foo"}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            QueryExecutors.onDelta().executeQuery("RESTORE TABLE default." + tableName + " TO VERSION AS OF 1", new QueryExecutor.QueryParam[0]);
            expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    @Test(groups={"delta-lake-oss", "profile_specific_tests"})
    public void testSelectForVersionAsOf() {
        String tableName = "test_dl_select_version" + TestingNames.randomNameSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (id INT, part STRING)USING delta PARTITIONED BY (part)LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 'spark')", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("ALTER TABLE default." + tableName + " ADD COLUMN new_column INT", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "spark"}));
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName + " VERSION AS OF 1", new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName + " FOR VERSION AS OF 1", new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            QueryExecutors.onDelta().executeQuery("CREATE OR REPLACE TABLE " + tableName + " USING DELTA AS SELECT id + 1 AS id, part, new_column FROM " + tableName, new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName + " VERSION AS OF 1", new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName + " FOR VERSION AS OF 1", new QueryExecutor.QueryParam[0]))).containsOnly((List)expectedRows);
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }
}

