/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestDeltaLakeUpdateCompatibility
extends BaseTestDeltaLakeS3Storage {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-databricks-104", "delta-lake-databricks-113", "delta-lake-databricks-122", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/14391", match="\\Q[Databricks][\\E(DatabricksJDBCDriver|JDBCDriver)\\Q](500593) Communication link failure. Failed to connect to server. Reason: \\E((HTTP retry after response received with no Retry-After header, error: HTTP Response code: 503|HTTP Response code: 504), Error message: Unknown.|java.net.SocketTimeoutException: Read timed out.)")
    public void testUpdatesFromDatabricks() {
        String tableName = "test_updates_" + TestingNames.randomNameSuffix();
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default.\"" + tableName + "\" (id, value) WITH (location = 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "') AS VALUES   (1, 'Poland'), (2, 'Germany'), (3, 'Romania')", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3})});
        try {
            QueryResult databricksResult = QueryExecutors.onDelta().executeQuery(String.format("SELECT * FROM default.%s ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            QueryResult prestoResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.default.\"%s\" ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)databricksResult)).containsExactlyInOrder(TestDeltaLakeUpdateCompatibility.toRows(prestoResult));
            QueryExecutors.onDelta().executeQuery(String.format("UPDATE default.%s SET value = 'France' WHERE id = 2", tableName), new QueryExecutor.QueryParam[0]);
            databricksResult = QueryExecutors.onDelta().executeQuery(String.format("SELECT * FROM default.%s ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            prestoResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.default.\"%s\" ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)databricksResult)).containsExactlyInOrder(TestDeltaLakeUpdateCompatibility.toRows(prestoResult));
            QueryExecutors.onDelta().executeQuery(String.format("UPDATE default.%s SET value = 'Spain' WHERE id = 2", tableName), new QueryExecutor.QueryParam[0]);
            databricksResult = QueryExecutors.onDelta().executeQuery(String.format("SELECT * FROM default.%s ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            prestoResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.default.\"%s\" ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)databricksResult)).containsExactlyInOrder(TestDeltaLakeUpdateCompatibility.toRows(prestoResult));
            QueryExecutors.onDelta().executeQuery(String.format("UPDATE default.%s SET value = 'Portugal' WHERE id = 2", tableName), new QueryExecutor.QueryParam[0]);
            databricksResult = QueryExecutors.onDelta().executeQuery(String.format("SELECT * FROM default.%s ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            prestoResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.default.\"%s\" ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            ((QueryAssert)Assertions.assertThat((AssertProvider)databricksResult)).containsExactlyInOrder(TestDeltaLakeUpdateCompatibility.toRows(prestoResult));
        }
        finally {
            DeltaLakeTestUtils.dropDeltaTableWithRetry("default." + tableName);
        }
    }

    private static List<QueryAssert.Row> toRows(QueryResult result) {
        return (List)result.rows().stream().map(QueryAssert.Row::new).collect(ImmutableList.toImmutableList());
    }
}

