/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;

public final class TransactionLogAssertions {
    private TransactionLogAssertions() {
    }

    public static void assertLastEntryIsCheckpointed(AmazonS3 s3Client, String bucketName, String tableName) {
        Optional lastJsonEntry = TransactionLogAssertions.listJsonLogEntries(s3Client, bucketName, tableName).stream().max(String::compareTo);
        Assertions.assertThat(lastJsonEntry).isPresent();
        Optional lastCheckpointEntry = TransactionLogAssertions.listCheckpointEntries(s3Client, bucketName, tableName).stream().max(String::compareTo);
        Assertions.assertThat(lastCheckpointEntry).isPresent();
        Assertions.assertThat((String)((String)lastJsonEntry.get()).replace(".json", "")).isEqualTo(((String)lastCheckpointEntry.get()).replace(".checkpoint.parquet", ""));
    }

    public static void assertTransactionLogVersion(AmazonS3 s3Client, String bucketName, String tableName, int versionNumber) {
        Optional lastJsonEntry = TransactionLogAssertions.listJsonLogEntries(s3Client, bucketName, tableName).stream().max(String::compareTo);
        Assertions.assertThat(lastJsonEntry).isPresent();
        Assertions.assertThat((String)((String)lastJsonEntry.get())).isEqualTo(String.format("%020d.json", versionNumber));
    }

    private static List<String> listJsonLogEntries(AmazonS3 s3Client, String bucketName, String tableName) {
        return TransactionLogAssertions.listLogEntries(s3Client, bucketName, tableName, file -> file.endsWith(".json"));
    }

    private static List<String> listCheckpointEntries(AmazonS3 s3Client, String bucketName, String tableName) {
        return TransactionLogAssertions.listLogEntries(s3Client, bucketName, tableName, file -> file.endsWith(".checkpoint.parquet"));
    }

    private static List<String> listLogEntries(AmazonS3 s3Client, String bucketName, String tableName, Predicate<String> fileFilter) {
        String prefix = "databricks-compatibility-test-" + tableName + "/_delta_log/";
        ListObjectsV2Result listResult = s3Client.listObjectsV2(bucketName, prefix);
        return (List)listResult.getObjectSummaries().stream().map(s3Object -> {
            String[] path = s3Object.getKey().split("/");
            return path[path.length - 1];
        }).filter(fileFilter).collect(ImmutableList.toImmutableList());
    }
}

