/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.exasol;

import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testing.TestingNames;
import io.trino.tests.product.utils.QueryExecutors;
import java.math.BigDecimal;
import org.testng.annotations.Test;

public class TestExasol
extends ProductTest {
    @Test(groups={"exasol", "profile_specific_tests"})
    public void testSelect() {
        String schemaName = "test_" + TestingNames.randomNameSuffix();
        String tableName = schemaName + ".tab";
        QueryExecutors.onExasol().executeQuery("CREATE SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onExasol().executeQuery("CREATE TABLE " + tableName + " (id integer, name varchar(5))", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onExasol().executeQuery("INSERT INTO " + tableName + " VALUES (1, 'a')", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{BigDecimal.valueOf(1L), "a"})});
        }
        finally {
            QueryExecutors.onExasol().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
            QueryExecutors.onExasol().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
        }
    }
}

