/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.trino.tempto.AfterMethodWithContext;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestComments
extends ProductTest {
    private static final String COMMENT_TABLE_NAME = "comment_test";
    private static final String COMMENT_VIEW_NAME = "comment_view_test";
    private static final String COMMENT_COLUMN_NAME = "comment_column_test";
    private static final String COMMENT_HIVE_VIEW_NAME = "comment_hive_view_test";

    @BeforeMethodWithContext
    @AfterMethodWithContext
    public void dropTestTable() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS comment_test", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP VIEW IF EXISTS comment_view_test", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS comment_column_test", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS comment_hive_view_test", new QueryExecutor.QueryParam[0]);
    }

    @Test
    public void testCommentTable() {
        String createTableSql = String.format("CREATE TABLE hive.default.%s (\n   c1 bigint\n)\nCOMMENT 'old comment'\nWITH (\n   format = 'RCBINARY'\n)", COMMENT_TABLE_NAME);
        QueryExecutors.onTrino().executeQuery(createTableSql, new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)TestComments.getTableComment("hive", "default", COMMENT_TABLE_NAME)).isEqualTo("old comment");
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON TABLE %s IS 'new comment'", COMMENT_TABLE_NAME), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)TestComments.getTableComment("hive", "default", COMMENT_TABLE_NAME)).isEqualTo("new comment");
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON TABLE %s IS ''", COMMENT_TABLE_NAME), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)TestComments.getTableComment("hive", "default", COMMENT_TABLE_NAME)).isEmpty();
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON TABLE %s IS NULL", COMMENT_TABLE_NAME), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)TestComments.getTableComment("hive", "default", COMMENT_TABLE_NAME)).isNull();
    }

    @Test
    public void testCommentView() {
        String createViewSql = String.format("CREATE VIEW hive.default.%s COMMENT 'old comment' AS SELECT 1 AS col", COMMENT_VIEW_NAME);
        QueryExecutors.onTrino().executeQuery(createViewSql, new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)TestComments.getTableComment("hive", "default", COMMENT_VIEW_NAME)).isEqualTo("old comment");
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON VIEW %s IS 'new comment'", COMMENT_VIEW_NAME), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)TestComments.getTableComment("hive", "default", COMMENT_VIEW_NAME)).isEqualTo("new comment");
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON VIEW %s IS ''", COMMENT_VIEW_NAME), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)TestComments.getTableComment("hive", "default", COMMENT_VIEW_NAME)).isEmpty();
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON VIEW %s IS NULL", COMMENT_VIEW_NAME), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)TestComments.getTableComment("hive", "default", COMMENT_VIEW_NAME)).isNull();
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE hive.default.%s (col int)", COMMENT_TABLE_NAME), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("CREATE VIEW default.%s AS SELECT * FROM default.%s", COMMENT_HIVE_VIEW_NAME, COMMENT_TABLE_NAME), new QueryExecutor.QueryParam[0]);
        Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON VIEW %s IS NULL", COMMENT_HIVE_VIEW_NAME), new QueryExecutor.QueryParam[0])).hasMessageContaining("Hive views are not supported");
    }

    private static String getTableComment(String catalogName, String schemaName, String tableName) {
        String sql = "SELECT comment FROM system.metadata.table_comments WHERE catalog_name = '" + catalogName + "' AND schema_name = '" + schemaName + "' AND table_name = '" + tableName + "'";
        return (String)QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]).getOnlyValue();
    }

    @Test
    public void testCommentViewColumn() {
        String columnName = "col";
        String createViewSql = String.format("CREATE VIEW hive.default.%s AS SELECT 1 AS %s", COMMENT_VIEW_NAME, columnName);
        QueryExecutors.onTrino().executeQuery(createViewSql, new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)this.getColumnComment("default", COMMENT_VIEW_NAME, columnName)).isNull();
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON COLUMN %s.%s IS 'new col comment'", COMMENT_VIEW_NAME, columnName), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)this.getColumnComment("default", COMMENT_VIEW_NAME, columnName)).isEqualTo("new col comment");
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON COLUMN %s.%s IS ''", COMMENT_VIEW_NAME, columnName), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)this.getColumnComment("default", COMMENT_VIEW_NAME, columnName)).isEmpty();
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON COLUMN %s.%s IS NULL", COMMENT_VIEW_NAME, columnName), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)this.getColumnComment("default", COMMENT_VIEW_NAME, columnName)).isNull();
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE hive.default.%s (col int)", COMMENT_TABLE_NAME), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("CREATE VIEW default.%s AS SELECT * FROM default.%s", COMMENT_HIVE_VIEW_NAME, COMMENT_TABLE_NAME), new QueryExecutor.QueryParam[0]);
        Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON COLUMN %s.%s IS NULL", COMMENT_HIVE_VIEW_NAME, columnName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Hive views are not supported");
    }

    protected String getColumnComment(String schemaName, String tableName, String columnName) {
        String sql = "SELECT comment FROM information_schema.columns WHERE table_schema = '" + schemaName + "' AND table_name = '" + tableName + "' AND column_name = '" + columnName + "'";
        return (String)QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]).getOnlyValue();
    }

    @Test
    public void testCommentColumn() {
        QueryExecutors.onTrino().executeQuery("CREATE TABLE hive.default.%s (\n   c1 bigint COMMENT 'test comment',\n   c2 bigint COMMENT '',\n   c3 bigint,\n   c4 bigint COMMENT 'test partition comment',\n   c5 bigint COMMENT '',\n   c6 bigint\n)\nWITH (\n   partitioned_by = ARRAY['c4', 'c5', 'c6']\n)\n".formatted(COMMENT_COLUMN_NAME), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)this.getColumnComment("default", COMMENT_COLUMN_NAME, "c1")).isEqualTo("test comment");
        Assertions.assertThat((String)this.getColumnComment("default", COMMENT_COLUMN_NAME, "c2")).isEmpty();
        Assertions.assertThat((String)this.getColumnComment("default", COMMENT_COLUMN_NAME, "c3")).isNull();
        Assertions.assertThat((String)this.getColumnComment("default", COMMENT_COLUMN_NAME, "c4")).isEqualTo("test partition comment");
        Assertions.assertThat((String)this.getColumnComment("default", COMMENT_COLUMN_NAME, "c5")).isEmpty();
        Assertions.assertThat((String)this.getColumnComment("default", COMMENT_COLUMN_NAME, "c6")).isNull();
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON COLUMN %s.c1 IS 'new comment'", COMMENT_COLUMN_NAME), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)this.getColumnComment("default", COMMENT_COLUMN_NAME, "c1")).isEqualTo("new comment");
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON COLUMN %s.c4 IS 'new partition comment'", COMMENT_COLUMN_NAME), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)this.getColumnComment("default", COMMENT_COLUMN_NAME, "c4")).isEqualTo("new partition comment");
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON COLUMN %s.c1 IS ''", COMMENT_COLUMN_NAME), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)this.getColumnComment("default", COMMENT_COLUMN_NAME, "c1")).isEmpty();
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON COLUMN %s.c4 IS ''", COMMENT_COLUMN_NAME), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)this.getColumnComment("default", COMMENT_COLUMN_NAME, "c4")).isEmpty();
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON COLUMN %s.c1 IS NULL", COMMENT_COLUMN_NAME), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)this.getColumnComment("default", COMMENT_COLUMN_NAME, "c1")).isNull();
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON COLUMN %s.c4 IS NULL", COMMENT_COLUMN_NAME), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)this.getColumnComment("default", COMMENT_COLUMN_NAME, "c4")).isNull();
    }
}

