/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.fulfillment.table.hive.HiveDataSource;
import io.trino.tempto.fulfillment.table.hive.InlineDataSource;
import io.trino.tempto.hadoop.hdfs.HdfsClient;
import io.trino.tempto.internal.hadoop.hdfs.HdfsDataSourceWriter;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.hive.BaseTestSyncPartitionMetadata;
import io.trino.tests.product.utils.QueryExecutors;
import org.testng.annotations.Test;

public class TestHdfsSyncPartitionMetadata
extends BaseTestSyncPartitionMetadata {
    @Inject
    @Named(value="databases.hive.warehouse_directory_path")
    private String warehouseDirectory;
    @Inject
    private HdfsClient hdfsClient;
    @Inject
    private HdfsDataSourceWriter hdfsDataSourceWriter;

    @Override
    protected String schemaLocation() {
        return this.warehouseDirectory;
    }

    @Override
    @Test(groups={"smoke", "trino_jdbc"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testAddPartition() {
        super.testAddPartition();
    }

    @Override
    @Test(groups={"smoke", "trino_jdbc"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testAddPartitionContainingCharactersThatNeedUrlEncoding() {
        super.testAddPartitionContainingCharactersThatNeedUrlEncoding();
    }

    @Override
    @Test(groups={"smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testDropPartition() {
        super.testDropPartition();
    }

    @Override
    @Test(groups={"smoke", "trino_jdbc"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testDropPartitionContainingCharactersThatNeedUrlEncoding() {
        super.testDropPartitionContainingCharactersThatNeedUrlEncoding();
    }

    @Override
    @Test(groups={"smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testFullSyncPartition() {
        super.testFullSyncPartition();
    }

    @Override
    @Test(groups={"smoke", "trino_jdbc"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testInvalidSyncMode() {
        super.testInvalidSyncMode();
    }

    @Override
    @Test(groups={"smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testMixedCasePartitionNames() {
        super.testMixedCasePartitionNames();
    }

    @Override
    @Test(groups={"smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testConflictingMixedCasePartitionNames() {
        super.testConflictingMixedCasePartitionNames();
    }

    @Override
    @Test(groups={"smoke"})
    public void testSyncPartitionMetadataWithNullArgument() {
        super.testSyncPartitionMetadataWithNullArgument();
    }

    @Test(groups={"smoke"})
    public void testAddNonConventionalHivePartition() {
        String tableName = "test_sync_partition_metadata_add_partition_nonconventional";
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        String tableLocation = this.tableLocation(tableName);
        this.makeHdfsDirectory(tableLocation);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (payload bigint, col_x varchar, col_y varchar) WITH (external_location = '%s', format = 'ORC', partitioned_by = ARRAY[ 'col_x', 'col_y' ])", tableName, tableLocation), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO " + tableName + " VALUES (1024, '10', '1'), (2048, '20', '11')", new QueryExecutor.QueryParam[0]);
        String unconventionalPartitionLocation = this.schemaLocation() + "/unconventionalpartition";
        this.makeHdfsDirectory(unconventionalPartitionLocation);
        this.copyOrcFileToHdfsDirectory(tableName, unconventionalPartitionLocation);
        QueryExecutors.onHive().executeQuery("ALTER TABLE %s ADD PARTITION (col_x = '30', col_y = '31') LOCATION '%s'".formatted(tableName, unconventionalPartitionLocation), new QueryExecutor.QueryParam[0]);
        TestHdfsSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"10", "1"}), QueryAssert.Row.row((Object[])new Object[]{"20", "11"}), QueryAssert.Row.row((Object[])new Object[]{"30", "31"}));
        TestHdfsSyncPartitionMetadata.cleanup(tableName);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (payload bigint, col_x varchar, col_y varchar) WITH (external_location = '%s', format = 'ORC', partitioned_by = ARRAY[ 'col_x', 'col_y' ])", tableName, tableLocation), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CALL system.sync_partition_metadata('default', '" + tableName + "', 'FULL')", new QueryExecutor.QueryParam[0]);
        TestHdfsSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"10", "1"}), QueryAssert.Row.row((Object[])new Object[]{"20", "11"}));
        QueryExecutors.onTrino().executeQuery("CALL system.sync_partition_metadata('default', '" + tableName + "', 'FULL')", new QueryExecutor.QueryParam[0]);
        TestHdfsSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"10", "1"}), QueryAssert.Row.row((Object[])new Object[]{"20", "11"}));
        this.removeHdfsDirectory(unconventionalPartitionLocation);
        TestHdfsSyncPartitionMetadata.cleanup(tableName);
        this.removeHdfsDirectory(tableLocation);
    }

    @Override
    protected void removeHdfsDirectory(String path) {
        this.hdfsClient.delete(path);
    }

    @Override
    protected void makeHdfsDirectory(String path) {
        this.hdfsClient.createDirectory(path);
    }

    @Override
    protected void copyOrcFileToHdfsDirectory(String tableName, String targetDirectory) {
        HiveDataSource dataSource = InlineDataSource.createResourceDataSource((String)tableName, (String)"io/trino/tests/product/hive/data/single_int_column/data.orc");
        this.hdfsDataSourceWriter.ensureDataOnHdfs(targetDirectory, dataSource);
    }

    @Override
    protected void createTable(String tableName, String tableLocation) {
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + tableName + " (payload bigint, col_x varchar, col_y varchar) WITH (format = 'ORC', partitioned_by = ARRAY[ 'col_x', 'col_y' ])", new QueryExecutor.QueryParam[0]);
    }
}

