/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.collect.ImmutableMap;
import io.trino.tempto.Requirement;
import io.trino.tempto.Requirements;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.Requires;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.fulfillment.table.MutableTableRequirement;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.hive.HiveTableDefinition;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.BaseTestHiveCoercion;
import io.trino.tests.product.utils.QueryExecutors;
import java.sql.JDBCType;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestHiveCoercionOnPartitionedTable
extends BaseTestHiveCoercion {
    public static final HiveTableDefinition HIVE_COERCION_TEXTFILE = TestHiveCoercionOnPartitionedTable.tableDefinitionBuilder("TEXTFILE", Optional.empty(), Optional.of("DELIMITED FIELDS TERMINATED BY '|'")).setNoData().build();
    public static final HiveTableDefinition HIVE_TIMESTAMP_COERCION_TEXTFILE = TestHiveCoercionOnPartitionedTable.tableDefinitionForTimestampCoercionBuilder("TEXTFILE", Optional.empty(), Optional.of("DELIMITED FIELDS TERMINATED BY '|'")).setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_PARQUET = TestHiveCoercionOnPartitionedTable.tableDefinitionBuilder("PARQUET", Optional.empty(), Optional.empty()).setNoData().build();
    public static final HiveTableDefinition HIVE_TIMESTAMP_COERCION_PARQUET = TestHiveCoercionOnPartitionedTable.tableDefinitionForTimestampCoercionBuilder("PARQUET", Optional.empty(), Optional.empty()).setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_AVRO = TestHiveCoercionOnPartitionedTable.avroTableDefinitionBuilder().setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_ORC = TestHiveCoercionOnPartitionedTable.tableDefinitionBuilder("ORC", Optional.empty(), Optional.empty()).setNoData().build();
    public static final HiveTableDefinition HIVE_TIMESTAMP_COERCION_ORC = TestHiveCoercionOnPartitionedTable.tableDefinitionForTimestampCoercionBuilder("ORC", Optional.empty(), Optional.empty()).setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_RCTEXT = TestHiveCoercionOnPartitionedTable.tableDefinitionBuilder("RCFILE", Optional.of("RCTEXT"), Optional.of("SERDE 'org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe'")).setNoData().build();
    public static final HiveTableDefinition HIVE_TIMESTAMP_COERCION_RCTEXT = TestHiveCoercionOnPartitionedTable.tableDefinitionForTimestampCoercionBuilder("RCFILE", Optional.of("RCTEXT"), Optional.of("SERDE 'org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe'")).setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_RCBINARY = TestHiveCoercionOnPartitionedTable.tableDefinitionBuilder("RCFILE", Optional.of("RCBINARY"), Optional.of("SERDE 'org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe'")).setNoData().build();
    public static final HiveTableDefinition HIVE_TIMESTAMP_COERCION_RCBINARY = TestHiveCoercionOnPartitionedTable.tableDefinitionForTimestampCoercionBuilder("RCFILE", Optional.of("RCBINARY"), Optional.of("SERDE 'org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe'")).setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_SEQUENCE = TestHiveCoercionOnPartitionedTable.tableDefinitionBuilder("SEQUENCEFILE", Optional.empty(), Optional.empty()).setNoData().build();
    public static final HiveTableDefinition HIVE_TIMESTAMP_COERCION_SEQUENCE = TestHiveCoercionOnPartitionedTable.tableDefinitionForTimestampCoercionBuilder("SEQUENCEFILE", Optional.empty(), Optional.empty()).setNoData().build();

    private static HiveTableDefinition.HiveTableDefinitionBuilder tableDefinitionBuilder(String fileFormat, Optional<String> recommendTableName, Optional<String> rowFormat) {
        String tableName = String.format("%s_hive_coercion_partitioned", recommendTableName.orElse(fileFormat).toLowerCase(Locale.ENGLISH));
        String varcharTypeForBooleanCoercion = fileFormat.toLowerCase(Locale.ENGLISH).contains("orc") ? "VARCHAR(5)" : "STRING";
        return HiveTableDefinition.builder((String)tableName).setCreateTableDDLTemplate("CREATE TABLE %NAME%(    row_to_row                 STRUCT<keep: STRING, ti2si: TINYINT, si2int: SMALLINT, int2bi: INT, bi2vc: BIGINT, lower2uppercase: BIGINT>,     list_to_list               ARRAY<STRUCT<ti2int: TINYINT, si2bi: SMALLINT, bi2vc: BIGINT, remove: STRING>>,     map_to_map                 MAP<TINYINT, STRUCT<ti2bi: TINYINT, int2bi: INT, float2double: FLOAT>>,     boolean_to_varchar         BOOLEAN,    string_to_boolean          STRING,    special_string_to_boolean  STRING,    numeric_string_to_boolean  STRING,    varchar_to_boolean         " + varcharTypeForBooleanCoercion + ",    tinyint_to_smallint        TINYINT,    tinyint_to_int             TINYINT,    tinyint_to_bigint          TINYINT,    tinyint_to_varchar         TINYINT,    tinyint_to_string          TINYINT,    tinyint_to_double          TINYINT,    tinyint_to_shortdecimal    TINYINT,    tinyint_to_longdecimal     TINYINT,    smallint_to_int            SMALLINT,    smallint_to_bigint         SMALLINT,    smallint_to_varchar        SMALLINT,    smallint_to_string         SMALLINT,    smallint_to_double         SMALLINT,    smallint_to_shortdecimal   SMALLINT,    smallint_to_longdecimal    SMALLINT,    int_to_bigint              INT,    int_to_varchar             INT,    int_to_string              INT,    int_to_double              INT,    int_to_shortdecimal        INT,    int_to_longdecimal         INT,    bigint_to_double           BIGINT,    bigint_to_varchar          BIGINT,    bigint_to_string           BIGINT,    bigint_to_shortdecimal     BIGINT,    bigint_to_longdecimal      BIGINT,    float_to_double            FLOAT,    float_to_string            FLOAT,    float_to_bounded_varchar   FLOAT,    float_infinity_to_string   FLOAT,    double_to_float            DOUBLE,    double_to_string           DOUBLE,    double_to_bounded_varchar  DOUBLE,    double_infinity_to_string  DOUBLE,    shortdecimal_to_shortdecimal          DECIMAL(10,2),    shortdecimal_to_longdecimal           DECIMAL(10,2),    longdecimal_to_shortdecimal           DECIMAL(20,12),    longdecimal_to_longdecimal            DECIMAL(20,12),    longdecimal_to_tinyint                DECIMAL(20,12),    shortdecimal_to_tinyint               DECIMAL(10,2),    longdecimal_to_smallint               DECIMAL(20,12),    shortdecimal_to_smallint              DECIMAL(10,2),    too_big_shortdecimal_to_smallint      DECIMAL(10,2),    longdecimal_to_int                    DECIMAL(20,12),    shortdecimal_to_int                   DECIMAL(10,2),    shortdecimal_with_0_scale_to_int      DECIMAL(10,0),    longdecimal_to_bigint                 DECIMAL(20,4),    shortdecimal_to_bigint                DECIMAL(10,2),    float_to_decimal                      FLOAT,    double_to_decimal          DOUBLE,    decimal_to_float                   DECIMAL(10,5),    decimal_to_double                  DECIMAL(10,5),    short_decimal_to_varchar           DECIMAL(10,5),    long_decimal_to_varchar            DECIMAL(20,12),    short_decimal_to_bounded_varchar   DECIMAL(10,5),    long_decimal_to_bounded_varchar    DECIMAL(20,12),    varchar_to_tinyint                 VARCHAR(4),    string_to_tinyint                  STRING,    varchar_to_smallint                VARCHAR(6),    string_to_smallint                 STRING,    varchar_to_integer                 VARCHAR(11),    string_to_integer                  STRING,    varchar_to_bigint                  VARCHAR(40),    string_to_bigint                   STRING,    varchar_to_bigger_varchar          VARCHAR(3),    varchar_to_smaller_varchar         VARCHAR(3),    varchar_to_date                    VARCHAR(10),    varchar_to_distant_date            VARCHAR(12),    varchar_to_float                   VARCHAR(40),    string_to_float                    STRING,    varchar_to_float_infinity          VARCHAR(40),    varchar_to_special_float           VARCHAR(40),    varchar_to_double                  VARCHAR(40),    string_to_double                   STRING,    varchar_to_double_infinity         VARCHAR(40),    varchar_to_special_double          VARCHAR(40),    date_to_string                     DATE,    date_to_bounded_varchar            DATE,    char_to_bigger_char                CHAR(3),    char_to_smaller_char               CHAR(3),    char_to_string                     CHAR(3),    char_to_bigger_varchar             CHAR(3),    char_to_smaller_varchar            CHAR(3),    string_to_char                     STRING,    varchar_to_bigger_char             VARCHAR(4),    varchar_to_smaller_char            VARCHAR(20),    timestamp_millis_to_date           TIMESTAMP,    timestamp_micros_to_date           TIMESTAMP,    timestamp_nanos_to_date            TIMESTAMP,    timestamp_to_string                TIMESTAMP,    timestamp_to_bounded_varchar       TIMESTAMP,    timestamp_to_smaller_varchar       TIMESTAMP,    smaller_varchar_to_timestamp       VARCHAR(4),    varchar_to_timestamp               STRING,    binary_to_string                   BINARY,    binary_to_smaller_varchar          BINARY) PARTITIONED BY (id BIGINT) " + rowFormat.map(s -> String.format("ROW FORMAT %s ", s)).orElse("") + "STORED AS " + fileFormat);
    }

    private static HiveTableDefinition.HiveTableDefinitionBuilder tableDefinitionForTimestampCoercionBuilder(String fileFormat, Optional<String> tablePrefix, Optional<String> rowFormat) {
        String tableName = String.format("%s_hive_timestamp_coercion_partitioned", tablePrefix.orElse(fileFormat).toLowerCase(Locale.ENGLISH));
        return HiveTableDefinition.builder((String)tableName).setCreateTableDDLTemplate("CREATE TABLE %NAME%(    timestamp_row_to_row                 STRUCT<keep: TIMESTAMP, si2i: SMALLINT, timestamp2string: TIMESTAMP, string2timestamp: STRING, timestamp2date: TIMESTAMP>,     timestamp_list_to_list               ARRAY<STRUCT<keep: TIMESTAMP, si2i: SMALLINT, timestamp2string: TIMESTAMP, string2timestamp: STRING, timestamp2date: TIMESTAMP>>,     timestamp_map_to_map                 MAP<SMALLINT, STRUCT<keep: TIMESTAMP, si2i: SMALLINT, timestamp2string: TIMESTAMP, string2timestamp: STRING, timestamp2date: TIMESTAMP>>,    timestamp_to_string                  TIMESTAMP,    string_to_timestamp                  STRING,    timestamp_to_date                    TIMESTAMP) PARTITIONED BY (id BIGINT) " + rowFormat.map(s -> String.format("ROW FORMAT %s ", s)).orElse("") + "STORED AS " + fileFormat);
    }

    private static HiveTableDefinition.HiveTableDefinitionBuilder avroTableDefinitionBuilder() {
        return HiveTableDefinition.builder((String)"avro_hive_coercion").setCreateTableDDLTemplate("CREATE TABLE %NAME%(    int_to_bigint              INT,    float_to_double            DOUBLE) PARTITIONED BY (id BIGINT) STORED AS AVRO");
    }

    @Requires(value={TextRequirements.class})
    @Test(groups={"jdbc"})
    public void testHiveCoercionTextFile() {
        this.doTestHiveCoercion(HIVE_COERCION_TEXTFILE);
    }

    @Requires(value={TextRequirements.class})
    @Test(groups={"jdbc"})
    public void testHiveCoercionWithDifferentTimestampPrecisionTextFile() {
        this.doTestHiveCoercionWithDifferentTimestampPrecision(HIVE_TIMESTAMP_COERCION_TEXTFILE);
    }

    @Requires(value={OrcRequirements.class})
    @Test(groups={"jdbc"})
    public void testHiveCoercionOrc() {
        this.doTestHiveCoercion(HIVE_COERCION_ORC);
    }

    @Requires(value={OrcRequirements.class})
    @Test(groups={"jdbc"})
    public void testHiveCoercionWithDifferentTimestampPrecisionOrc() {
        this.doTestHiveCoercionWithDifferentTimestampPrecision(HIVE_TIMESTAMP_COERCION_ORC);
    }

    @Requires(value={RcTextRequirements.class})
    @Test(groups={"jdbc"})
    public void testHiveCoercionRcText() {
        this.doTestHiveCoercion(HIVE_COERCION_RCTEXT);
    }

    @Requires(value={RcTextRequirements.class})
    @Test(groups={"jdbc"})
    public void testHiveCoercionWithDifferentTimestampPrecisionRcText() {
        this.doTestHiveCoercionWithDifferentTimestampPrecision(HIVE_TIMESTAMP_COERCION_RCTEXT);
    }

    @Requires(value={RcBinaryRequirements.class})
    @Test(groups={"jdbc"})
    public void testHiveCoercionRcBinary() {
        this.doTestHiveCoercion(HIVE_COERCION_RCBINARY);
    }

    @Requires(value={RcBinaryRequirements.class})
    @Test(groups={"jdbc"})
    public void testHiveCoercionWithDifferentTimestampPrecisionRcBinary() {
        this.doTestHiveCoercionWithDifferentTimestampPrecision(HIVE_TIMESTAMP_COERCION_RCBINARY);
    }

    @Requires(value={ParquetRequirements.class})
    @Test(groups={"jdbc"})
    public void testHiveCoercionParquet() {
        this.doTestHiveCoercion(HIVE_COERCION_PARQUET);
    }

    @Requires(value={ParquetRequirements.class})
    @Test(groups={"jdbc"})
    public void testHiveCoercionWithDifferentTimestampPrecisionParquet() {
        this.doTestHiveCoercionWithDifferentTimestampPrecision(HIVE_TIMESTAMP_COERCION_PARQUET);
    }

    @Requires(value={SequenceRequirements.class})
    @Test(groups={"jdbc"})
    public void testHiveCoercionSequence() {
        this.doTestHiveCoercion(HIVE_COERCION_SEQUENCE);
    }

    @Requires(value={SequenceRequirements.class})
    @Test(groups={"jdbc"})
    public void testHiveCoercionWithDifferentTimestampPrecisionSequence() {
        this.doTestHiveCoercionWithDifferentTimestampPrecision(HIVE_TIMESTAMP_COERCION_SEQUENCE);
    }

    @Requires(value={AvroRequirements.class})
    @Test(groups={"jdbc"})
    public void testHiveCoercionAvro() {
        String tableName = TestHiveCoercionOnPartitionedTable.mutableTableInstanceOf((TableDefinition)HIVE_COERCION_AVRO).getNameInDatabase();
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s PARTITION (id=1) VALUES(2323, 0.5),(-2323, -1.5)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN int_to_bigint int_to_bigint bigint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN float_to_double float_to_double double", tableName), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW COLUMNS FROM " + tableName, new QueryExecutor.QueryParam[0]).project(new int[]{1, 2}))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"int_to_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"float_to_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"id", "bigint"})});
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)queryResult)).hasColumns(new JDBCType[]{JDBCType.BIGINT, JDBCType.DOUBLE, JDBCType.BIGINT});
        ((QueryAssert)Assertions.assertThat((AssertProvider)queryResult)).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2323L, 0.5, 1}), QueryAssert.Row.row((Object[])new Object[]{-2323L, -1.5, 1})});
    }

    @Override
    protected Map<BaseTestHiveCoercion.ColumnContext, String> expectedExceptionsWithHiveContext() {
        return ImmutableMap.builder().putAll(super.expectedExceptionsWithHiveContext()).put((Object)TestHiveCoercionOnPartitionedTable.columnContext("3.1", "parquet", "float_to_double"), (Object)"org.apache.hadoop.hive.serde2.io.DoubleWritable cannot be cast to org.apache.hadoop.io.FloatWritable").buildOrThrow();
    }

    public static final class SequenceRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return Requirements.compose((Requirement[])new Requirement[]{MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_SEQUENCE).withState(MutableTableRequirement.State.CREATED).build(), MutableTableRequirement.builder((TableDefinition)HIVE_TIMESTAMP_COERCION_SEQUENCE).withState(MutableTableRequirement.State.CREATED).build()});
        }
    }

    public static final class AvroRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_AVRO).withState(MutableTableRequirement.State.CREATED).build();
        }
    }

    public static final class ParquetRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return Requirements.compose((Requirement[])new Requirement[]{MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_PARQUET).withState(MutableTableRequirement.State.CREATED).build(), MutableTableRequirement.builder((TableDefinition)HIVE_TIMESTAMP_COERCION_PARQUET).withState(MutableTableRequirement.State.CREATED).build()});
        }
    }

    public static final class RcBinaryRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return Requirements.compose((Requirement[])new Requirement[]{MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_RCBINARY).withState(MutableTableRequirement.State.CREATED).build(), MutableTableRequirement.builder((TableDefinition)HIVE_TIMESTAMP_COERCION_RCBINARY).withState(MutableTableRequirement.State.CREATED).build()});
        }
    }

    public static final class RcTextRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return Requirements.compose((Requirement[])new Requirement[]{MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_RCTEXT).withState(MutableTableRequirement.State.CREATED).build(), MutableTableRequirement.builder((TableDefinition)HIVE_TIMESTAMP_COERCION_RCTEXT).withState(MutableTableRequirement.State.CREATED).build()});
        }
    }

    public static final class OrcRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return Requirements.compose((Requirement[])new Requirement[]{MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_ORC).withState(MutableTableRequirement.State.CREATED).build(), MutableTableRequirement.builder((TableDefinition)HIVE_TIMESTAMP_COERCION_ORC).withState(MutableTableRequirement.State.CREATED).build()});
        }
    }

    public static final class TextRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return Requirements.compose((Requirement[])new Requirement[]{MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_TEXTFILE).withState(MutableTableRequirement.State.CREATED).build(), MutableTableRequirement.builder((TableDefinition)HIVE_TIMESTAMP_COERCION_TEXTFILE).withState(MutableTableRequirement.State.CREATED).build()});
        }
    }
}

