/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.collect.ImmutableMap;
import io.trino.tempto.Requirement;
import io.trino.tempto.Requirements;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.Requires;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.fulfillment.table.MutableTableRequirement;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.hive.HiveTableDefinition;
import io.trino.tests.product.hive.BaseTestHiveCoercion;
import java.util.Locale;
import java.util.Map;
import org.testng.annotations.Test;

public class TestHiveCoercionOnUnpartitionedTable
extends BaseTestHiveCoercion {
    public static final HiveTableDefinition HIVE_COERCION_ORC = TestHiveCoercionOnUnpartitionedTable.tableDefinitionBuilder("ORC").setNoData().build();
    private static final HiveTableDefinition HIVE_COERCION_PARQUET = TestHiveCoercionOnUnpartitionedTable.tableDefinitionBuilder("PARQUET").setNoData().build();
    public static final HiveTableDefinition HIVE_TIMESTAMP_COERCION_ORC = TestHiveCoercionOnUnpartitionedTable.tableDefinitionForTimestampCoercionBuilder("ORC").setNoData().build();
    private static final HiveTableDefinition HIVE_TIMESTAMP_COERCION_PARQUET = TestHiveCoercionOnUnpartitionedTable.tableDefinitionForTimestampCoercionBuilder("PARQUET").setNoData().build();

    private static HiveTableDefinition.HiveTableDefinitionBuilder tableDefinitionBuilder(String fileFormat) {
        String tableName = String.format("%s_hive_coercion_unpartitioned", fileFormat.toLowerCase(Locale.ENGLISH));
        return HiveTableDefinition.builder((String)tableName).setCreateTableDDLTemplate(" CREATE TABLE %NAME%(\n     row_to_row                         STRUCT<keep: STRING, ti2si: TINYINT, si2int: SMALLINT, int2bi: INT, bi2vc: BIGINT, lower2uppercase: BIGINT>,\n     list_to_list                       ARRAY<STRUCT<ti2int: TINYINT, si2bi: SMALLINT, bi2vc: BIGINT, remove: STRING>>,\n     map_to_map                         MAP<TINYINT, STRUCT<ti2bi: TINYINT, int2bi: INT, float2double: FLOAT>>,\n     boolean_to_varchar                 BOOLEAN,\n     string_to_boolean                  STRING,\n     special_string_to_boolean          STRING,\n     numeric_string_to_boolean          STRING,\n     varchar_to_boolean                 VARCHAR(5),\n     tinyint_to_smallint                TINYINT,\n     tinyint_to_int                     TINYINT,\n     tinyint_to_bigint                  TINYINT,\n     tinyint_to_varchar                 TINYINT,\n     tinyint_to_string                  TINYINT,\n     tinyint_to_double                  TINYINT,\n     tinyint_to_shortdecimal            TINYINT,\n     tinyint_to_longdecimal             TINYINT,\n     smallint_to_int                    SMALLINT,\n     smallint_to_bigint                 SMALLINT,\n     smallint_to_varchar                SMALLINT,\n     smallint_to_string                 SMALLINT,\n     smallint_to_double                 SMALLINT,\n     smallint_to_shortdecimal           SMALLINT,\n     smallint_to_longdecimal            SMALLINT,\n     int_to_bigint                      INT,\n     int_to_varchar                     INT,\n     int_to_string                      INT,\n     int_to_double                      INT,\n     int_to_shortdecimal                INT,\n     int_to_longdecimal                 INT,\n     bigint_to_double                   BIGINT,\n     bigint_to_varchar                  BIGINT,\n     bigint_to_string                   BIGINT,\n     bigint_to_shortdecimal             BIGINT,\n     bigint_to_longdecimal              BIGINT,\n     float_to_double                    FLOAT,\n     float_to_string                    FLOAT,\n     float_to_bounded_varchar           FLOAT,\n     float_infinity_to_string           FLOAT,\n     double_to_float                    DOUBLE,\n     double_to_string                   DOUBLE,\n     double_to_bounded_varchar          DOUBLE,\n     double_infinity_to_string          DOUBLE,\n     shortdecimal_to_shortdecimal       DECIMAL(10,2),\n     shortdecimal_to_longdecimal        DECIMAL(10,2),\n     longdecimal_to_shortdecimal        DECIMAL(20,12),\n     longdecimal_to_longdecimal         DECIMAL(20,12),\n     longdecimal_to_tinyint             DECIMAL(20,12),\n     shortdecimal_to_tinyint            DECIMAL(10,2),\n     longdecimal_to_smallint            DECIMAL(20,12),\n     shortdecimal_to_smallint           DECIMAL(10,2),\n     too_big_shortdecimal_to_smallint   DECIMAL(10,2),\n     longdecimal_to_int                 DECIMAL(20,12),\n     shortdecimal_to_int                DECIMAL(10,2),\n     shortdecimal_with_0_scale_to_int   DECIMAL(10,0),\n     longdecimal_to_bigint              DECIMAL(20,4),\n     shortdecimal_to_bigint             DECIMAL(10,2),\n     float_to_decimal                   FLOAT,\n     double_to_decimal                  DOUBLE,\n     decimal_to_float                   DECIMAL(10,5),\n     decimal_to_double                  DECIMAL(10,5),\n     short_decimal_to_varchar           DECIMAL(10,5),\n     long_decimal_to_varchar            DECIMAL(20,12),\n     short_decimal_to_bounded_varchar   DECIMAL(10,5),\n     long_decimal_to_bounded_varchar    DECIMAL(20,12),\n     varchar_to_tinyint                 VARCHAR(4),\n     string_to_tinyint                  STRING,\n     varchar_to_smallint                VARCHAR(6),\n     string_to_smallint                 STRING,\n     varchar_to_integer                 VARCHAR(11),\n     string_to_integer                  STRING,\n     varchar_to_bigint                  VARCHAR(40),\n     string_to_bigint                   STRING,\n     varchar_to_bigger_varchar          VARCHAR(3),\n     varchar_to_smaller_varchar         VARCHAR(3),\n     varchar_to_date                    VARCHAR(10),\n     varchar_to_distant_date            VARCHAR(12),\n     varchar_to_float                   VARCHAR(40),\n     string_to_float                    STRING,\n     varchar_to_float_infinity          VARCHAR(40),\n     varchar_to_special_float           VARCHAR(40),\n     varchar_to_double                  VARCHAR(40),\n     string_to_double                   STRING,\n     varchar_to_double_infinity         VARCHAR(40),\n     varchar_to_special_double          VARCHAR(40),\n     date_to_string                     DATE,\n     date_to_bounded_varchar            DATE,\n     char_to_bigger_char                CHAR(3),\n     char_to_smaller_char               CHAR(3),\n     char_to_string                     CHAR(3),\n     char_to_bigger_varchar             CHAR(3),\n     char_to_smaller_varchar            CHAR(3),\n     string_to_char                     STRING,\n     varchar_to_bigger_char             VARCHAR(4),\n     varchar_to_smaller_char            VARCHAR(20),\n     timestamp_millis_to_date           TIMESTAMP,\n     timestamp_micros_to_date           TIMESTAMP,\n     timestamp_nanos_to_date            TIMESTAMP,\n     timestamp_to_string                TIMESTAMP,\n     timestamp_to_bounded_varchar       TIMESTAMP,\n     timestamp_to_smaller_varchar       TIMESTAMP,\n     smaller_varchar_to_timestamp       VARCHAR(4),\n     varchar_to_timestamp               STRING,\n     binary_to_string                   BINARY,\n     binary_to_smaller_varchar          BINARY,\n     id                                 BIGINT)\nSTORED AS " + fileFormat);
    }

    private static HiveTableDefinition.HiveTableDefinitionBuilder tableDefinitionForTimestampCoercionBuilder(String fileFormat) {
        String tableName = String.format("%s_hive_timestamp_coercion_unpartitioned", fileFormat.toLowerCase(Locale.ENGLISH));
        return HiveTableDefinition.builder((String)tableName).setCreateTableDDLTemplate(" CREATE TABLE %NAME%(\n     timestamp_row_to_row       STRUCT<keep: TIMESTAMP, si2i: SMALLINT, timestamp2string: TIMESTAMP, string2timestamp: STRING, timestamp2date: TIMESTAMP>,\n     timestamp_list_to_list     ARRAY<STRUCT<keep: TIMESTAMP, si2i: SMALLINT, timestamp2string: TIMESTAMP, string2timestamp: STRING, timestamp2date: TIMESTAMP>>,\n     timestamp_map_to_map       MAP<SMALLINT, STRUCT<keep: TIMESTAMP, si2i: SMALLINT, timestamp2string: TIMESTAMP, string2timestamp: STRING, timestamp2date: TIMESTAMP>>,\n     timestamp_to_string        TIMESTAMP,\n     string_to_timestamp        STRING,\n     timestamp_to_date          TIMESTAMP,\n     id                         BIGINT)\nSTORED AS " + fileFormat);
    }

    @Requires(value={OrcRequirements.class})
    @Test(groups={"jdbc"})
    public void testHiveCoercionOrc() {
        this.doTestHiveCoercion(HIVE_COERCION_ORC);
    }

    @Requires(value={OrcRequirements.class})
    @Test(groups={"jdbc"})
    public void testHiveCoercionWithDifferentTimestampPrecision() {
        this.doTestHiveCoercionWithDifferentTimestampPrecision(HIVE_TIMESTAMP_COERCION_ORC);
    }

    @Requires(value={ParquetRequirements.class})
    @Test(groups={"jdbc"})
    public void testHiveCoercionParquet() {
        this.doTestHiveCoercion(HIVE_COERCION_PARQUET);
    }

    @Requires(value={ParquetRequirements.class})
    @Test(groups={"jdbc"})
    public void testHiveCoercionWithDifferentTimestampPrecisionParquet() {
        this.doTestHiveCoercionWithDifferentTimestampPrecision(HIVE_TIMESTAMP_COERCION_PARQUET);
    }

    @Override
    protected Map<BaseTestHiveCoercion.ColumnContext, String> expectedExceptionsWithTrinoContext() {
        return ImmutableMap.builder().put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "row_to_row"), (Object)"Unsupported Trino column type (varchar) for Parquet column ([row_to_row, bi2vc] optional int64 bi2vc (INTEGER(64,true)))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "list_to_list"), (Object)"Unsupported Trino column type (varchar) for Parquet column ([list_to_list, list, element, bi2vc] optional int64 bi2vc (INTEGER(64,true)))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "boolean_to_varchar"), (Object)"Unsupported Trino column type (varchar(5)) for Parquet column ([boolean_to_varchar] optional boolean boolean_to_varchar)").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "string_to_boolean"), (Object)"Unsupported Trino column type (boolean) for Parquet column ([string_to_boolean] optional binary string_to_boolean (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "special_string_to_boolean"), (Object)"Unsupported Trino column type (boolean) for Parquet column ([special_string_to_boolean] optional binary special_string_to_boolean (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "numeric_string_to_boolean"), (Object)"Unsupported Trino column type (boolean) for Parquet column ([numeric_string_to_boolean] optional binary numeric_string_to_boolean (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "varchar_to_boolean"), (Object)"Unsupported Trino column type (boolean) for Parquet column ([varchar_to_boolean] optional binary varchar_to_boolean (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "tinyint_to_longdecimal"), (Object)"Unsupported Trino column type (decimal(20,2)) for Parquet column ([tinyint_to_longdecimal] optional int32 tinyint_to_longdecimal (INTEGER(8,true)))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "smallint_to_longdecimal"), (Object)"Unsupported Trino column type (decimal(20,2)) for Parquet column ([smallint_to_longdecimal] optional int32 smallint_to_longdecimal (INTEGER(16,true)))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "int_to_longdecimal"), (Object)"Unsupported Trino column type (decimal(20,2)) for Parquet column ([int_to_longdecimal] optional int32 int_to_longdecimal (INTEGER(32,true)))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "bigint_to_shortdecimal"), (Object)"Unsupported Trino column type (decimal(10,2)) for Parquet column ([bigint_to_shortdecimal] optional int64 bigint_to_shortdecimal (INTEGER(64,true)))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "bigint_to_longdecimal"), (Object)"Unsupported Trino column type (decimal(20,2)) for Parquet column ([bigint_to_longdecimal] optional int64 bigint_to_longdecimal (INTEGER(64,true)))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "longdecimal_to_tinyint"), (Object)"Unsupported Trino column type (tinyint) for Parquet column ([longdecimal_to_tinyint] optional fixed_len_byte_array(9) longdecimal_to_tinyint (DECIMAL(20,12)))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "shortdecimal_to_tinyint"), (Object)"Unsupported Trino column type (tinyint) for Parquet column ([shortdecimal_to_tinyint] optional fixed_len_byte_array(5) shortdecimal_to_tinyint (DECIMAL(10,2)))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "longdecimal_to_smallint"), (Object)"Unsupported Trino column type (smallint) for Parquet column ([longdecimal_to_smallint] optional fixed_len_byte_array(9) longdecimal_to_smallint (DECIMAL(20,12)))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "shortdecimal_to_smallint"), (Object)"Unsupported Trino column type (smallint) for Parquet column ([shortdecimal_to_smallint] optional fixed_len_byte_array(5) shortdecimal_to_smallint (DECIMAL(10,2)))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "too_big_shortdecimal_to_smallint"), (Object)"Unsupported Trino column type (smallint) for Parquet column ([too_big_shortdecimal_to_smallint] optional fixed_len_byte_array(5) too_big_shortdecimal_to_smallint (DECIMAL(10,2)))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "longdecimal_to_int"), (Object)"Unsupported Trino column type (integer) for Parquet column ([longdecimal_to_int] optional fixed_len_byte_array(9) longdecimal_to_int (DECIMAL(20,12)))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "shortdecimal_to_int"), (Object)"Unsupported Trino column type (integer) for Parquet column ([shortdecimal_to_int] optional fixed_len_byte_array(5) shortdecimal_to_int (DECIMAL(10,2)))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "longdecimal_to_bigint"), (Object)"Unsupported Trino column type (bigint) for Parquet column ([longdecimal_to_bigint] optional fixed_len_byte_array(9) longdecimal_to_bigint (DECIMAL(20,4)))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "shortdecimal_to_bigint"), (Object)"Unsupported Trino column type (bigint) for Parquet column ([shortdecimal_to_bigint] optional fixed_len_byte_array(5) shortdecimal_to_bigint (DECIMAL(10,2)))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "float_to_decimal"), (Object)"Unsupported Trino column type (decimal(10,5)) for Parquet column ([float_to_decimal] optional float float_to_decimal)").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "double_to_float"), (Object)"Unsupported Trino column type (real) for Parquet column ([double_to_float] optional double double_to_float)").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "double_to_decimal"), (Object)"Unsupported Trino column type (decimal(10,5)) for Parquet column ([double_to_decimal] optional double double_to_decimal)").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "decimal_to_float"), (Object)"Unsupported Trino column type (double) for Parquet column ([decimal_to_float] optional fixed_len_byte_array(5) decimal_to_float (DECIMAL(10,5)))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "decimal_to_double"), (Object)"Unsupported Trino column type (double) for Parquet column ([decimal_to_double] optional fixed_len_byte_array(5) decimal_to_double (DECIMAL(10,5)))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "short_decimal_to_bounded_varchar"), (Object)"Unsupported Trino column type (varchar(30)) for Parquet column ([short_decimal_to_bounded_varchar] optional fixed_len_byte_array(5) short_decimal_to_bounded_varchar (DECIMAL(10,5)))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "long_decimal_to_bounded_varchar"), (Object)"Unsupported Trino column type (varchar(30)) for Parquet column ([long_decimal_to_bounded_varchar] optional fixed_len_byte_array(9) long_decimal_to_bounded_varchar (DECIMAL(20,12)))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "varchar_to_tinyint"), (Object)"Unsupported Trino column type (tinyint) for Parquet column ([varchar_to_tinyint] optional binary varchar_to_tinyint (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "string_to_tinyint"), (Object)"Unsupported Trino column type (tinyint) for Parquet column ([string_to_tinyint] optional binary string_to_tinyint (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "varchar_to_smallint"), (Object)"Unsupported Trino column type (smallint) for Parquet column ([varchar_to_smallint] optional binary varchar_to_smallint (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "string_to_smallint"), (Object)"Unsupported Trino column type (smallint) for Parquet column ([string_to_smallint] optional binary string_to_smallint (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "varchar_to_integer"), (Object)"Unsupported Trino column type (integer) for Parquet column ([varchar_to_integer] optional binary varchar_to_integer (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "string_to_integer"), (Object)"Unsupported Trino column type (integer) for Parquet column ([string_to_integer] optional binary string_to_integer (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "varchar_to_bigint"), (Object)"Unsupported Trino column type (bigint) for Parquet column ([varchar_to_bigint] optional binary varchar_to_bigint (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "string_to_bigint"), (Object)"Unsupported Trino column type (bigint) for Parquet column ([string_to_bigint] optional binary string_to_bigint (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "varchar_to_date"), (Object)"Unsupported Trino column type (date) for Parquet column ([varchar_to_date] optional binary varchar_to_date (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "varchar_to_distant_date"), (Object)"Unsupported Trino column type (date) for Parquet column ([varchar_to_distant_date] optional binary varchar_to_distant_date (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "varchar_to_float"), (Object)"Unsupported Trino column type (double) for Parquet column ([varchar_to_float] optional binary varchar_to_float (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "string_to_float"), (Object)"Unsupported Trino column type (double) for Parquet column ([string_to_float] optional binary string_to_float (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "varchar_to_float_infinity"), (Object)"Unsupported Trino column type (double) for Parquet column ([varchar_to_float_infinity] optional binary varchar_to_float_infinity (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "varchar_to_special_float"), (Object)"Unsupported Trino column type (double) for Parquet column ([varchar_to_special_float] optional binary varchar_to_special_float (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "varchar_to_double"), (Object)"Unsupported Trino column type (double) for Parquet column ([varchar_to_double] optional binary varchar_to_double (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "string_to_double"), (Object)"Unsupported Trino column type (double) for Parquet column ([string_to_double] optional binary string_to_double (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "varchar_to_double_infinity"), (Object)"Unsupported Trino column type (double) for Parquet column ([varchar_to_double_infinity] optional binary varchar_to_double_infinity (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "varchar_to_special_double"), (Object)"Unsupported Trino column type (double) for Parquet column ([varchar_to_special_double] optional binary varchar_to_special_double (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "date_to_string"), (Object)"Unsupported Trino column type (varchar) for Parquet column ([date_to_string] optional int32 date_to_string (DATE))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "date_to_bounded_varchar"), (Object)"Unsupported Trino column type (varchar(12)) for Parquet column ([date_to_bounded_varchar] optional int32 date_to_bounded_varchar (DATE))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "timestamp_millis_to_date"), (Object)"Unsupported Trino column type (date) for Parquet column ([timestamp_millis_to_date] optional int96 timestamp_millis_to_date)").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "timestamp_micros_to_date"), (Object)"Unsupported Trino column type (date) for Parquet column ([timestamp_micros_to_date] optional int96 timestamp_micros_to_date)").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "timestamp_nanos_to_date"), (Object)"Unsupported Trino column type (date) for Parquet column ([timestamp_nanos_to_date] optional int96 timestamp_nanos_to_date)").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "smaller_varchar_to_timestamp"), (Object)"Unsupported Trino column type (timestamp(3)) for Parquet column ([smaller_varchar_to_timestamp] optional binary smaller_varchar_to_timestamp (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "varchar_to_timestamp"), (Object)"Unsupported Trino column type (timestamp(3)) for Parquet column ([varchar_to_timestamp] optional binary varchar_to_timestamp (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "timestamp_row_to_row"), (Object)"Unsupported Trino column type (varchar) for Parquet column ([timestamp_row_to_row, timestamp2string] optional int96 timestamp2string)").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "timestamp_list_to_list"), (Object)"Unsupported Trino column type (varchar) for Parquet column ([timestamp_list_to_list, list, element, timestamp2string] optional int96 timestamp2string)").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "timestamp_map_to_map"), (Object)"Unsupported Trino column type (varchar) for Parquet column ([timestamp_map_to_map, key_value, value, timestamp2string] optional int96 timestamp2string)").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "string_to_timestamp"), (Object)"Unsupported Trino column type (timestamp(3)) for Parquet column ([string_to_timestamp] optional binary string_to_timestamp (STRING))").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("parquet", "timestamp_to_date"), (Object)"Unsupported Trino column type (date) for Parquet column ([timestamp_to_date] optional int96 timestamp_to_date))").buildOrThrow();
    }

    @Override
    protected Map<BaseTestHiveCoercion.ColumnContext, String> expectedExceptionsWithHiveContext() {
        return ImmutableMap.builder().putAll(super.expectedExceptionsWithHiveContext()).put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "string_to_boolean"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.io.BooleanWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "special_string_to_boolean"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.io.BooleanWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "numeric_string_to_boolean"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.io.BooleanWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "varchar_to_boolean"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.io.BooleanWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "float_to_decimal"), (Object)"org.apache.hadoop.io.FloatWritable cannot be cast to org.apache.hadoop.hive.serde2.io.HiveDecimalWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "double_to_decimal"), (Object)"org.apache.hadoop.io.DoubleWritable cannot be cast to org.apache.hadoop.hive.serde2.io.HiveDecimalWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "decimal_to_float"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.DoubleWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "decimal_to_double"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.DoubleWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "longdecimal_to_tinyint"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "shortdecimal_to_tinyint"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "longdecimal_to_smallint"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "shortdecimal_to_smallint"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "too_big_shortdecimal_to_smallint"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "longdecimal_to_int"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "shortdecimal_to_int"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "shortdecimal_with_0_scale_to_int"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "longdecimal_to_bigint"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.LongWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "shortdecimal_to_bigint"), (Object)"org.apache.hadoop.hive.serde2.io.HiveDecimalWritable cannot be cast to org.apache.hadoop.io.LongWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "varchar_to_tinyint"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "string_to_tinyint"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.hive.serde2.io.ByteWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "varchar_to_smallint"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "string_to_smallint"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.hive.serde2.io.ShortWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "varchar_to_integer"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "string_to_integer"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.io.IntWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "varchar_to_bigint"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.io.LongWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "string_to_bigint"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.io.LongWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "varchar_to_date"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.hive.serde2.io.DateWritableV2").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "varchar_to_distant_date"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.hive.serde2.io.DateWritableV2").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "varchar_to_float"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.io.DoubleWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "string_to_float"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.io.DoubleWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "varchar_to_float_infinity"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.io.DoubleWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "varchar_to_special_float"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.io.DoubleWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "varchar_to_double"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.io.DoubleWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "string_to_double"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.io.DoubleWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "varchar_to_double_infinity"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.io.DoubleWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "varchar_to_special_double"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.io.DoubleWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "date_to_string"), (Object)"Cannot inspect org.apache.hadoop.hive.serde2.io.DateWritableV2").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "date_to_bounded_varchar"), (Object)"Cannot inspect org.apache.hadoop.hive.serde2.io.DateWritableV2").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "timestamp_millis_to_date"), (Object)"org.apache.hadoop.hive.serde2.io.TimestampWritableV2 cannot be cast to org.apache.hadoop.hive.serde2.io.DateWritableV2").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "timestamp_micros_to_date"), (Object)"org.apache.hadoop.hive.serde2.io.TimestampWritableV2 cannot be cast to org.apache.hadoop.hive.serde2.io.DateWritableV2").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "timestamp_nanos_to_date"), (Object)"org.apache.hadoop.hive.serde2.io.TimestampWritableV2 cannot be cast to org.apache.hadoop.hive.serde2.io.DateWritableV2").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "smaller_varchar_to_timestamp"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.hive.serde2.io.TimestampWritableV2").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "varchar_to_timestamp"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.hive.serde2.io.TimestampWritableV2").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "timestamp_row_to_row"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.hive.serde2.io.TimestampWritableV2").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "timestamp_list_to_list"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.hive.serde2.io.TimestampWritableV2").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "timestamp_map_to_map"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.hive.serde2.io.TimestampWritableV2").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "string_to_timestamp"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.hive.serde2.io.TimestampWritableV2").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "timestamp_to_date"), (Object)"org.apache.hadoop.io.Text cannot be cast to org.apache.hadoop.hive.serde2.io.TimestampWritableV2").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "double_to_float"), (Object)"org.apache.hadoop.hive.serde2.io.DoubleWritable cannot be cast to org.apache.hadoop.io.FloatWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "binary_to_string"), (Object)"org.apache.hadoop.io.BytesWritable cannot be cast to org.apache.hadoop.hive.serde2.io.HiveVarcharWritable").put((Object)TestHiveCoercionOnUnpartitionedTable.columnContext("3.1", "parquet", "binary_to_smaller_varchar"), (Object)"org.apache.hadoop.io.BytesWritable cannot be cast to org.apache.hadoop.hive.serde2.io.HiveVarcharWritable").buildOrThrow();
    }

    public static final class ParquetRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return Requirements.compose((Requirement[])new Requirement[]{MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_PARQUET).withState(MutableTableRequirement.State.CREATED).build(), MutableTableRequirement.builder((TableDefinition)HIVE_TIMESTAMP_COERCION_PARQUET).withState(MutableTableRequirement.State.CREATED).build()});
        }
    }

    public static final class OrcRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return Requirements.compose((Requirement[])new Requirement[]{MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_ORC).withState(MutableTableRequirement.State.CREATED).build(), MutableTableRequirement.builder((TableDefinition)HIVE_TIMESTAMP_COERCION_ORC).withState(MutableTableRequirement.State.CREATED).build()});
        }
    }
}

