/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.airlift.units.Duration;
import io.trino.plugin.hive.metastore.thrift.DefaultThriftMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.HiveMetastoreAuthentication;
import io.trino.plugin.hive.metastore.thrift.NoHiveMetastoreAuthentication;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClientFactory;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.TException;

public final class TestHiveMetastoreClientFactory {
    private final ThriftMetastoreClientFactory thriftMetastoreClientFactory = new DefaultThriftMetastoreClientFactory(Optional.empty(), Optional.empty(), new Duration(10.0, TimeUnit.SECONDS), new Duration(10.0, TimeUnit.SECONDS), (HiveMetastoreAuthentication)new NoHiveMetastoreAuthentication(), "localhost", Optional.empty());
    @Inject
    @Named(value="databases.hive.metastore.host")
    private String metastoreHost;
    @Inject
    @Named(value="databases.hive.metastore.port")
    private int metastorePort;

    public ThriftMetastoreClient createMetastoreClient() throws TException {
        URI metastore = URI.create("thrift://" + this.metastoreHost + ":" + this.metastorePort);
        return this.thriftMetastoreClientFactory.create(metastore, Optional.empty());
    }
}

