/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.airlift.log.Logger;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutionException;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.tests.product.hive.HiveProductTest;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.JdbcDriverUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.sql.SQLException;
import java.util.function.Supplier;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestHivePartitionSchemaEvolution
extends HiveProductTest {
    private static final Logger log = Logger.get(TestHivePartitionSchemaEvolution.class);
    @Inject
    @Named(value="databases.hive.enforce_non_transactional_tables")
    private boolean createTablesAsAcid;

    @BeforeMethodWithContext
    public void useColumnMappingByName() throws SQLException {
        JdbcDriverUtils.setSessionProperty(QueryExecutors.onTrino().getConnection(), "hive.parquet_use_column_names", "true");
        JdbcDriverUtils.setSessionProperty(QueryExecutors.onTrino().getConnection(), "hive.orc_use_column_names", "true");
    }

    @Test
    public void testParquet() {
        this.test(() -> this.createTable("PARQUET"));
    }

    @Test
    public void testOrc() {
        this.test(() -> this.createTable("ORC"));
    }

    private void test(Supplier<TemporaryHiveTable> temporaryHiveTableSupplier) {
        try (TemporaryHiveTable table = temporaryHiveTableSupplier.get();){
            this.testEvolution(table, "ALTER TABLE %s REPLACE COLUMNS (float_column float, varchar_column varchar(20))", QueryAssert.Row.row((Object[])new Object[]{1.1, "jeden", 1}));
            this.testEvolution(table, "ALTER TABLE %s REPLACE COLUMNS (int_column int, varchar_column varchar(20))", QueryAssert.Row.row((Object[])new Object[]{1, "jeden", 1}));
            this.testEvolution(table, "ALTER TABLE %s REPLACE COLUMNS (int_column int, float_column float)", QueryAssert.Row.row((Object[])new Object[]{1, 1.1, 1}));
            this.testEvolution(table, "ALTER TABLE %s REPLACE COLUMNS (tiny_column tinyint, int_column int, float_column float, varchar_column varchar(20))", QueryAssert.Row.row((Object[])new Object[]{null, 1, 1.1, "jeden", 1}));
            this.testEvolution(table, "ALTER TABLE %s REPLACE COLUMNS (int_column int, tiny_column tinyint, float_column float, varchar_column varchar(20))", QueryAssert.Row.row((Object[])new Object[]{1, null, 1.1, "jeden", 1}));
            this.testEvolution(table, "ALTER TABLE %s REPLACE COLUMNS (int_column int, float_column float, varchar_column varchar(20), tiny_column tinyint)", QueryAssert.Row.row((Object[])new Object[]{1, 1.1, "jeden", null, 1}));
            this.testEvolution(table, "ALTER TABLE %s REPLACE COLUMNS (int_column int, tiny_column tinyint, varchar_column varchar(20))", QueryAssert.Row.row((Object[])new Object[]{1, null, "jeden", 1}));
            this.testEvolution(table, "ALTER TABLE %s REPLACE COLUMNS (int_column bigint, float_column double, varchar_column varchar(20))", QueryAssert.Row.row((Object[])new Object[]{1, 1.1, "jeden", 1}));
            this.testEvolution(table, "ALTER TABLE %s REPLACE COLUMNS (varchar_column varchar(20), float_column double, int_column bigint)", QueryAssert.Row.row((Object[])new Object[]{"jeden", 1.1, 1, 1}));
            this.testEvolution(table, "ALTER TABLE %s REPLACE COLUMNS (float_column double, int_column bigint)", QueryAssert.Row.row((Object[])new Object[]{1.1, 1, 1}));
            this.testEvolution(table, "ALTER TABLE %s REPLACE COLUMNS (varchar_column varchar(20), tiny_column tinyint, float_column double, int_column bigint)", QueryAssert.Row.row((Object[])new Object[]{"jeden", null, 1.1, 1, 1}));
        }
    }

    private void testEvolution(TemporaryHiveTable table, String sql, QueryAssert.Row row) {
        if (TestHivePartitionSchemaEvolution.tryExecuteOnHive(String.format(sql, table.getName()))) {
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + table.getName(), new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{row});
        }
    }

    private static boolean tryExecuteOnHive(String sql) {
        try {
            QueryExecutors.onHive().executeQuery(sql, new QueryExecutor.QueryParam[0]);
            return true;
        }
        catch (QueryExecutionException e) {
            String message = e.getMessage();
            if (message.contains("Unable to alter table. The following columns have types incompatible with the existing columns in their respective positions") || message.contains("Replacing columns cannot drop columns") || message.contains("Replace columns is not supported for")) {
                log.warn("Unable to execute: %s, due: %s", new Object[]{sql, message});
                return false;
            }
            throw e;
        }
    }

    private TemporaryHiveTable createTable(String format) {
        String tableName = "schema_evolution_" + TestingNames.randomNameSuffix();
        TestHivePartitionSchemaEvolution.tryExecuteOnHive(String.format("CREATE TABLE %s (  int_column int,  float_column float,  varchar_column varchar(20)) PARTITIONED BY (partition_column bigint) STORED AS %s " + (this.createTablesAsAcid ? "TBLPROPERTIES ('transactional_properties' = 'none', 'transactional' = 'false')" : ""), tableName, format));
        TemporaryHiveTable temporaryHiveTable = TemporaryHiveTable.temporaryHiveTable(tableName);
        try {
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES (1, 1.1, 'jeden', 1)", tableName), new QueryExecutor.QueryParam[0]);
        }
        catch (Exception e) {
            temporaryHiveTable.closeQuietly(e);
            throw e;
        }
        return temporaryHiveTable;
    }
}

