/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.collect.ImmutableList;
import io.trino.jdbc.Row;
import io.trino.tempto.Requires;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.fulfillment.table.hive.tpch.ImmutableTpchTablesRequirements;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.hive.AbstractTestHiveViews;
import io.trino.tests.product.utils.QueryExecutors;
import java.math.BigDecimal;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class, ImmutableTpchTablesRequirements.ImmutableOrdersTable.class})
public class TestHiveViews
extends AbstractTestHiveViews {
    @Override
    protected List<QueryAssert.Row> getExpectedHiveViewTextualColumnsTypes() {
        return ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"a_char_1", "char(1)"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"a_char_255", "char(255)"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"a_varchar_1", "varchar"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"a_varchar_65535", "varchar"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"a_string", "varchar"}));
    }

    @Test
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testFailingHiveViewsWithMetadataListing() {
        TestHiveViews.setupBrokenView();
        this.testFailingHiveViewsWithInformationSchema();
        this.testFailingHiveViewsWithSystemJdbc();
        QueryExecutors.onHive().executeQuery("DROP SCHEMA IF EXISTS test_list_failing_views CASCADE", new QueryExecutor.QueryParam[0]);
    }

    private void testFailingHiveViewsWithInformationSchema() {
        String withSchemaFilter = "SELECT table_name FROM information_schema.views WHERE table_schema = 'test_list_failing_views'";
        String withNoFilter = "SELECT table_name FROM information_schema.views";
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(withSchemaFilter, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"correct_view"})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(withNoFilter, new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"correct_view"})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT table_name FROM information_schema.views WHERE table_schema = 'test_list_failing_views' AND table_name = 'correct_view'", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"correct_view"})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT table_name FROM information_schema.views WHERE table_schema = 'test_list_failing_views' AND table_name = 'failing_view'", new QueryExecutor.QueryParam[0]))).hasNoRows();
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = 'test_list_failing_views'", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"correct_view", "n_nationkey"}), QueryAssert.Row.row((Object[])new Object[]{"correct_view", "n_name"}), QueryAssert.Row.row((Object[])new Object[]{"correct_view", "n_regionkey"}), QueryAssert.Row.row((Object[])new Object[]{"correct_view", "n_comment"}), QueryAssert.Row.row((Object[])new Object[]{"failing_view", "col0"})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM information_schema.columns WHERE table_schema = 'test_list_failing_views' AND table_name = 'failing_view'", new QueryExecutor.QueryParam[0]))).hasNoRows();
    }

    private void testFailingHiveViewsWithSystemJdbc() {
        String withSchemaFilter = "SELECT table_name FROM system.jdbc.tables WHERE table_cat = 'hive' AND table_schem = 'test_list_failing_views' AND table_type = 'VIEW'";
        String withNoFilter = "SELECT table_name FROM system.jdbc.tables WHERE table_cat = 'hive' AND table_type = 'VIEW'";
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(withSchemaFilter, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"correct_view"}), QueryAssert.Row.row((Object[])new Object[]{"failing_view"})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(withNoFilter, new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"correct_view"}), QueryAssert.Row.row((Object[])new Object[]{"failing_view"})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT table_name FROM system.jdbc.tables WHERE table_cat = 'hive' AND table_schem = 'test_list_failing_views' AND table_name = 'correct_view'", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"correct_view"})});
        Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("SELECT table_name FROM system.jdbc.tables WHERE table_cat = 'hive' AND table_schem = 'test_list_failing_views' AND table_name = 'failing_view'", new QueryExecutor.QueryParam[0])).hasMessageContaining("Failed to translate Hive view 'test_list_failing_views.failing_view'");
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT table_name, column_name FROM system.jdbc.columns WHERE table_cat = 'hive' AND table_schem = 'test_list_failing_views'", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"correct_view", "n_nationkey"}), QueryAssert.Row.row((Object[])new Object[]{"correct_view", "n_name"}), QueryAssert.Row.row((Object[])new Object[]{"correct_view", "n_regionkey"}), QueryAssert.Row.row((Object[])new Object[]{"correct_view", "n_comment"}), QueryAssert.Row.row((Object[])new Object[]{"failing_view", "col0"})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM system.jdbc.columns WHERE table_cat = 'hive' AND table_schem = 'test_list_failing_views' AND table_name = 'failing_view'", new QueryExecutor.QueryParam[0]))).hasNoRows();
    }

    private static void setupBrokenView() {
        QueryExecutors.onHive().executeQuery("DROP SCHEMA IF EXISTS test_list_failing_views CASCADE", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE SCHEMA test_list_failing_views", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_list_failing_views.correct_view AS SELECT * FROM nation limit 5", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE test_list_failing_views.table_dropped (col0 BIGINT)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_list_failing_views.failing_view AS SELECT * FROM test_list_failing_views.table_dropped", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP TABLE test_list_failing_views.table_dropped", new QueryExecutor.QueryParam[0]);
        Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM test_list_failing_views.failing_view", new QueryExecutor.QueryParam[0])).hasMessageContaining("Failed to translate Hive view 'test_list_failing_views.failing_view'");
    }

    @Test
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testLateralViewExplode() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS pageAds", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE pageAds(pageid, adid_list) WITH (format='TEXTFILE') AS VALUES   (VARCHAR 'two', ARRAY[11, 22]),   ('nothing', NULL),   ('zero', ARRAY[]),   ('one', ARRAY[42])", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_lateral_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_lateral_view as SELECT pageid, adid FROM pageAds LATERAL VIEW explode(adid_list) adTable AS adid", new QueryExecutor.QueryParam[0]);
        TestHiveViews.assertViewQuery("SELECT * FROM hive_lateral_view", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"two", 11}), QueryAssert.Row.row((Object[])new Object[]{"two", 22}), QueryAssert.Row.row((Object[])new Object[]{"one", 42})}));
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_lateral_view_outer_explode", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_lateral_view_outer_explode as SELECT pageid, adid FROM pageAds LATERAL VIEW OUTER explode(adid_list) adTable AS adid", new QueryExecutor.QueryParam[0]);
        TestHiveViews.assertViewQuery("SELECT * FROM hive_lateral_view_outer_explode", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"two", 11}), QueryAssert.Row.row((Object[])new Object[]{"two", 22}), QueryAssert.Row.row((Object[])new Object[]{"one", 42}), QueryAssert.Row.row((Object[])new Object[]{"nothing", null}), QueryAssert.Row.row((Object[])new Object[]{"zero", null})}));
    }

    @Test
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testLateralViewExplodeArrayOfStructs() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS pageAdsStructs", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE pageAdsStructs(pageid VARCHAR, adid_list ARRAY(ROW(a INTEGER, b INTEGER))) WITH (format='TEXTFILE')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO pageAdsStructs VALUES   ('two', ARRAY[ROW(11, 12), ROW(13, 14)]),   ('nothing', NULL),   ('zero', ARRAY[]),   ('one', ARRAY[ROW(42, 43)])", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_lateral_view_structs", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_lateral_view_structs as SELECT pageid, adid FROM pageAdsStructs LATERAL VIEW explode(adid_list) adTable AS adid", new QueryExecutor.QueryParam[0]);
        TestHiveViews.assertViewQuery("SELECT pageid, adid.a, adid.b FROM hive_lateral_view_structs", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"two", 11, 12}), QueryAssert.Row.row((Object[])new Object[]{"two", 13, 14}), QueryAssert.Row.row((Object[])new Object[]{"one", 42, 43})}));
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_lateral_view_structs_outer_explode", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_lateral_view_structs_outer_explode as SELECT pageid, adid FROM pageAdsStructs LATERAL VIEW OUTER explode(adid_list) adTable AS adid", new QueryExecutor.QueryParam[0]);
        TestHiveViews.assertViewQuery("SELECT pageid, adid.a, adid.b FROM hive_lateral_view_structs_outer_explode", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"two", 11, 12}), QueryAssert.Row.row((Object[])new Object[]{"two", 13, 14}), QueryAssert.Row.row((Object[])new Object[]{"one", 42, 43}), QueryAssert.Row.row((Object[])new Object[]{"nothing", null, null}), QueryAssert.Row.row((Object[])new Object[]{"zero", null, null})}));
    }

    @Test
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testLateralViewJsonTupleAs() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS test_json_tuple_table", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE test_json_tuple_table WITH (format='TEXTFILE') AS SELECT 3 id, CAST('{\"user_id\": 1000, \"first.name\": \"Mateusz\", \"Last Name\": \"Gajewski\", \".NET\": true, \"aNull\": null}' AS varchar) jsonstr", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS test_json_tuple_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_json_tuple_view AS SELECT `t`.`id`, `x`.`a`, `x`.`b`, `x`.`c`, `x`.`d`, `x`.`e`, `x`.`f` FROM test_json_tuple_table AS `t` LATERAL VIEW json_tuple(`t`.`jsonstr`, \"first.name\", \"Last Name\", '.NET', \"user_id\", \"aNull\", \"nonexistentField\") `x` AS `a`, `b`, `c`, `d`, `e`, `f`", new QueryExecutor.QueryParam[0]);
        TestHiveViews.assertViewQuery("SELECT * FROM test_json_tuple_view", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3, "Mateusz", "Gajewski", "true", "1000", null, null})}));
    }

    @Test
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testFromUtcTimestamp() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS test_from_utc_timestamp_source", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_from_utc_timestamp_source (  source_tinyint tinyint,   source_smallint smallint,   source_integer int,   source_bigint bigint,   source_float float,   source_double double,   source_decimal_three decimal(10,3),   source_decimal_zero decimal(10,0),   source_timestamp timestamp,   source_date date)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO test_from_utc_timestamp_source VALUES (   123,   10123,   259200123,   2592000123,   2592000.0,   2592000.123,   2592000.123,  2592000,  timestamp '1970-01-30 16:00:00.000',   date '1970-01-30')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS test_from_utc_timestamp_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_from_utc_timestamp_view AS SELECT    CAST(from_utc_timestamp(source_tinyint, 'America/Los_Angeles') AS STRING) ts_tinyint,    CAST(from_utc_timestamp(source_tinyint, 'PST') AS STRING) ts_tinyint_short_tz,    CAST(from_utc_timestamp(source_smallint, 'America/Los_Angeles') AS STRING) ts_smallint,    CAST(from_utc_timestamp(source_smallint, 'PST') AS STRING) ts_smallint_short_tz,    CAST(from_utc_timestamp(source_integer, 'America/Los_Angeles') AS STRING) ts_integer,    CAST(from_utc_timestamp(source_integer, 'PST') AS STRING) ts_integer_short_tz,    CAST(from_utc_timestamp(source_bigint, 'America/Los_Angeles') AS STRING) ts_bigint,    CAST(from_utc_timestamp(source_bigint, 'PST') AS STRING) ts_bigint_short_tz,    CAST(from_utc_timestamp(source_float, 'America/Los_Angeles') AS STRING) ts_float,    CAST(from_utc_timestamp(source_float, 'PST') AS STRING) ts_float_short_tz,    CAST(from_utc_timestamp(source_double, 'America/Los_Angeles') AS STRING) ts_double,    CAST(from_utc_timestamp(source_double, 'PST') AS STRING) ts_double_short_tz,    CAST(from_utc_timestamp(source_decimal_three, 'America/Los_Angeles') AS STRING) ts_decimal_three,    CAST(from_utc_timestamp(source_decimal_three, 'PST') AS STRING) ts_decimal_three_short_tz,    CAST(from_utc_timestamp(source_decimal_zero, 'America/Los_Angeles') AS STRING) ts_decimal_zero,    CAST(from_utc_timestamp(source_decimal_zero, 'PST') AS STRING) ts_decimal_zero_short_tz,    CAST(from_utc_timestamp(source_timestamp, 'America/Los_Angeles') AS STRING) ts_timestamp,    CAST(from_utc_timestamp(source_timestamp, 'PST') AS STRING) ts_timestamp_short_tz,    CAST(from_utc_timestamp(source_date, 'America/Los_Angeles') AS STRING) ts_date,    CAST(from_utc_timestamp(source_date, 'PST') AS STRING) ts_date_short_tz FROM test_from_utc_timestamp_source", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM test_from_utc_timestamp_view", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1969-12-31 16:00:00.123", "1969-12-31 16:00:00.123", "1969-12-31 16:00:10.123", "1969-12-31 16:00:10.123", "1970-01-03 16:00:00.123", "1970-01-03 16:00:00.123", "1970-01-30 16:00:00.123", "1970-01-30 16:00:00.123", "1970-01-30 16:00:00.000", "1970-01-30 16:00:00.000", "1970-01-30 16:00:00.123", "1970-01-30 16:00:00.123", "1970-01-30 16:00:00.123", "1970-01-30 16:00:00.123", "1970-01-30 16:00:00.000", "1970-01-30 16:00:00.000", "1970-01-30 08:00:00.000", "1970-01-30 08:00:00.000", "1970-01-29 16:00:00.000", "1970-01-29 16:00:00.000"})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onHive().executeQuery("SELECT * FROM test_from_utc_timestamp_view", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1969-12-31 16:00:00.123", "1969-12-31 16:00:00.123", "1969-12-31 16:00:10.123", "1969-12-31 16:00:10.123", "1970-01-03 16:00:00.123", "1970-01-03 16:00:00.123", "1970-01-30 16:00:00.123", "1970-01-30 16:00:00.123", "1970-01-30 16:00:00", "1970-01-30 16:00:00", "1970-01-30 16:00:00.123", "1970-01-30 16:00:00.123", "1970-01-30 16:00:00.123", "1970-01-30 16:00:00.123", "1970-01-30 16:00:00", "1970-01-30 16:00:00", "1970-01-30 08:00:00", "1970-01-30 08:00:00", "1970-01-29 16:00:00", "1970-01-29 16:00:00"})});
    }

    @Test
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testFromUtcTimestampInvalidTimeZone() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS test_from_utc_timestamp_invalid_time_zone_source", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_from_utc_timestamp_invalid_time_zone_source (source_timestamp timestamp)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO test_from_utc_timestamp_invalid_time_zone_source VALUES (timestamp '1970-01-30 16:00:00.000')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS test_from_utc_timestamp_invalid_time_zone_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_from_utc_timestamp_invalid_time_zone_view AS SELECT    CAST(from_utc_timestamp(source_timestamp, 'Matrix/Zion') AS STRING) ts_timestamp FROM test_from_utc_timestamp_invalid_time_zone_source", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM test_from_utc_timestamp_invalid_time_zone_view", new QueryExecutor.QueryParam[0])).hasMessageContaining("'Matrix/Zion' is not a valid time zone");
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onHive().executeQuery("SELECT * FROM test_from_utc_timestamp_invalid_time_zone_view", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1970-01-30 16:00:00"})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE test_from_utc_timestamp_invalid_time_zone_source", new QueryExecutor.QueryParam[0]);
    }

    @Test
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testNestedFieldWithReservedKeyNames() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS test_nested_field_with_reserved_key_names_source", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_nested_field_with_reserved_key_names_source (nested_field_key_word_lower_case struct<`from`:BIGINT>, nested_field_key_word_upper_case struct<`FROM`:BIGINT>, nested_field_quote struct<`do...from`:BIGINT>)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO test_nested_field_with_reserved_key_names_source VALUES (row(row(1), row(2), row(3)))", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS test_nested_field_with_reserved_key_names_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_nested_field_with_reserved_key_names_view AS SELECT nested_field_key_word_lower_case, nested_field_key_word_upper_case, nested_field_quote FROM test_nested_field_with_reserved_key_names_source", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onHive().executeQuery("SELECT nested_field_key_word_lower_case, nested_field_key_word_upper_case, nested_field_quote FROM test_nested_field_with_reserved_key_names_view", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"{\"from\":1}", "{\"from\":2}", "{\"do...from\":3}"})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onHive().executeQuery("SELECT nested_field_key_word_lower_case.`from`, nested_field_key_word_upper_case.`from`, nested_field_quote.`do...from` FROM test_nested_field_with_reserved_key_names_view", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1L, 2L, 3L})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT nested_field_key_word_lower_case, nested_field_key_word_upper_case, nested_field_quote FROM test_nested_field_with_reserved_key_names_view", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{Row.builder().addField("from", (Object)1L).build(), Row.builder().addField("from", (Object)2L).build(), Row.builder().addField("do...from", (Object)3L).build()})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT nested_field_key_word_lower_case.\"from\", nested_field_key_word_upper_case.\"from\", nested_field_quote.\"do...from\" FROM test_nested_field_with_reserved_key_names_view", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1L, 2L, 3L})});
        QueryExecutors.onHive().executeQuery("DROP VIEW test_nested_field_with_reserved_key_names_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE test_nested_field_with_reserved_key_names_source", new QueryExecutor.QueryParam[0]);
    }

    @Test
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testFromUtcTimestampCornerCases() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS test_from_utc_timestamp_corner_cases_source", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE test_from_utc_timestamp_corner_cases_source AS SELECT * FROM (VALUES   CAST(-5000000000001 AS BIGINT),  CAST(-1000000000001 AS BIGINT),  -1,  1,  5000000000001)AS source(source_bigint)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS test_from_utc_timestamp_corner_cases_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_from_utc_timestamp_corner_cases_view AS SELECT    CAST(from_utc_timestamp(source_bigint, 'America/Los_Angeles') as STRING) ts_bigint FROM test_from_utc_timestamp_corner_cases_source", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM test_from_utc_timestamp_corner_cases_view", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1811-07-23 07:13:41.999"}), QueryAssert.Row.row((Object[])new Object[]{"1938-04-24 14:13:19.999"}), QueryAssert.Row.row((Object[])new Object[]{"1969-12-31 15:59:59.999"}), QueryAssert.Row.row((Object[])new Object[]{"1969-12-31 16:00:00.001"}), QueryAssert.Row.row((Object[])new Object[]{"2128-06-11 01:53:20.001"})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onHive().executeQuery("SELECT * FROM test_from_utc_timestamp_corner_cases_view", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1811-07-23 07:13:41.999"}), QueryAssert.Row.row((Object[])new Object[]{"1938-04-24 14:13:19.999"}), QueryAssert.Row.row((Object[])new Object[]{"1969-12-31 15:59:59.999"}), QueryAssert.Row.row((Object[])new Object[]{"1969-12-31 16:00:00.001"}), QueryAssert.Row.row((Object[])new Object[]{"2128-06-11 01:53:20.001"})});
    }

    @Test
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testCastTimestampAsDecimal() {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS cast_timestamp_as_decimal", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE cast_timestamp_as_decimal (a_timestamp TIMESTAMP)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO cast_timestamp_as_decimal VALUES ('1990-01-02 12:13:14.123456789')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS cast_timestamp_as_decimal_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW cast_timestamp_as_decimal_view AS SELECT CAST(a_timestamp as DECIMAL(10,0)) a_cast_timestamp FROM cast_timestamp_as_decimal", new QueryExecutor.QueryParam[0]);
        String testQuery = "SELECT * FROM cast_timestamp_as_decimal_view";
        TestHiveViews.assertViewQuery(testQuery, queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{new BigDecimal("631282394")})}));
        QueryExecutors.onHive().executeQuery("DROP VIEW cast_timestamp_as_decimal_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE cast_timestamp_as_decimal", new QueryExecutor.QueryParam[0]);
    }

    @Test
    @Flaky(issue="https://github.com/trinodb/trino/issues?q=is%3Aissue+issue%3A+4936+5427", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication|return code [12] from \\Qorg.apache.hadoop.hive.ql.exec.mr.MapRedTask\\E)")
    public void testUnionBetweenCharAndVarchar() {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS union_char_varchar", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE union_char_varchar (a_char char(1), a_varchar varchar(1024))", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO union_char_varchar VALUES ('a', 'Trino')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO union_char_varchar VALUES (NULL, NULL)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS union_char_varchar_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW union_char_varchar_view AS\nSELECT a_char AS col FROM union_char_varchar\nUNION ALL\nSELECT a_varchar AS col FROM union_char_varchar\n", new QueryExecutor.QueryParam[0]);
        List<QueryAssert.Row> expected = List.of(QueryAssert.Row.row((Object[])new Object[]{"a"}), QueryAssert.Row.row((Object[])new Object[]{"Trino"}), QueryAssert.Row.row((Object[])new Object[]{null}), QueryAssert.Row.row((Object[])new Object[]{null}));
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM union_char_varchar_view", new QueryExecutor.QueryParam[0]))).containsOnly(expected);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onHive().executeQuery("SELECT * FROM union_char_varchar_view", new QueryExecutor.QueryParam[0]))).containsOnly(expected);
        QueryExecutors.onHive().executeQuery("DROP VIEW union_char_varchar_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE union_char_varchar", new QueryExecutor.QueryParam[0]);
    }
}

