/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.io.Resources;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.AfterMethodWithContext;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.hadoop.hdfs.HdfsClient;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import java.io.InputStream;
import java.net.URL;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestTextFileHiveTable
extends ProductTest {
    @Inject
    private HdfsClient hdfsClient;
    @Inject
    @Named(value="databases.hive.warehouse_directory_path")
    private String warehouseDirectory;

    @BeforeMethodWithContext
    public void setup() throws Exception {
        this.hdfsClient.createDirectory(this.warehouseDirectory + "/TestTextFileHiveTable/single_column");
        try (InputStream inputStream = Resources.asByteSource((URL)Resources.getResource((String)"textfile/single_column.textfile")).openStream();){
            this.hdfsClient.saveFile(this.warehouseDirectory + "/TestTextFileHiveTable/single_column/single_column.textfile", inputStream);
        }
    }

    @AfterMethodWithContext
    public void cleanup() {
        this.hdfsClient.delete(this.warehouseDirectory + "/TestTextFileHiveTable");
    }

    @Test
    public void testCreateTextFileSkipHeaderFooter() {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_create_textfile_skip_header", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE test_create_textfile_skip_header (name varchar) WITH (    format = 'TEXTFILE',    external_location = 'hdfs://hadoop-master:9000%s/TestTextFileHiveTable/single_column',    skip_header_line_count = 1 )", this.warehouseDirectory), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM test_create_textfile_skip_header", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"value"}), QueryAssert.Row.row((Object[])new Object[]{"footer"})});
        QueryExecutors.onHive().executeQuery("DROP TABLE test_create_textfile_skip_header", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_create_textfile_skip_footer", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE test_create_textfile_skip_footer (name varchar) WITH (    format = 'TEXTFILE',    external_location = 'hdfs://hadoop-master:9000%s/TestTextFileHiveTable/single_column',    skip_footer_line_count = 1 )", this.warehouseDirectory), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM test_create_textfile_skip_footer", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"header"}), QueryAssert.Row.row((Object[])new Object[]{"value"})});
        QueryExecutors.onHive().executeQuery("DROP TABLE test_create_textfile_skip_footer", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_create_textfile_skip_header_footer", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE test_create_textfile_skip_header_footer (name varchar) WITH (    format = 'TEXTFILE',    external_location = 'hdfs://hadoop-master:9000%s/TestTextFileHiveTable/single_column',    skip_header_line_count = 1,    skip_footer_line_count = 1 )", this.warehouseDirectory), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM test_create_textfile_skip_header_footer", new QueryExecutor.QueryParam[0]))).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"value"})});
        QueryExecutors.onHive().executeQuery("DROP TABLE test_create_textfile_skip_header_footer", new QueryExecutor.QueryParam[0]);
    }

    @Test
    public void testInsertTextFileSkipHeaderFooter() {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_textfile_skip_header", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_textfile_skip_header  (col1 int) STORED AS TEXTFILE TBLPROPERTIES ('skip.header.line.count'='1')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO test_textfile_skip_header VALUES (1)", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM test_textfile_skip_header", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
        QueryExecutors.onHive().executeQuery("DROP TABLE test_textfile_skip_header", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_textfile_skip_footer", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_textfile_skip_footer  (col1 int) STORED AS TEXTFILE TBLPROPERTIES ('skip.footer.line.count'='1')", new QueryExecutor.QueryParam[0]);
        Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO test_textfile_skip_footer VALUES (1)", new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Inserting into Hive table with skip.footer.line.count property not supported");
        QueryExecutors.onHive().executeQuery("DROP TABLE test_textfile_skip_footer", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_textfile_skip_header_footer", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_textfile_skip_header_footer  (col1 int) STORED AS TEXTFILE TBLPROPERTIES ('skip.header.line.count'='1', 'skip.footer.line.count'='1')", new QueryExecutor.QueryParam[0]);
        Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO test_textfile_skip_header_footer VALUES (1)", new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Inserting into Hive table with skip.footer.line.count property not supported");
        QueryExecutors.onHive().executeQuery("DROP TABLE test_textfile_skip_header_footer", new QueryExecutor.QueryParam[0]);
    }

    @Test
    public void testCreateTextFileTableAsSelectSkipHeaderFooter() {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_create_textfile_skip_header", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE test_create_textfile_skip_header WITH (    format = 'TEXTFILE',    skip_header_line_count = 1 ) AS SELECT 1  AS col_header1, 2 as col_header2;", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO test_create_textfile_skip_header VALUES (3, 4)", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM test_create_textfile_skip_header", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 2}), QueryAssert.Row.row((Object[])new Object[]{3, 4})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onHive().executeQuery("SELECT * FROM test_create_textfile_skip_header", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 2}), QueryAssert.Row.row((Object[])new Object[]{3, 4})});
        QueryExecutors.onHive().executeQuery("DROP TABLE test_create_textfile_skip_header", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_create_textfile_skip_footer", new QueryExecutor.QueryParam[0]);
        Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("CREATE TABLE test_create_textfile_skip_footer WITH (    format = 'TEXTFILE',    skip_footer_line_count = 1 ) AS SELECT 1  AS col_header;", new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Creating Hive table with data with value of skip.footer.line.count property greater than 0 is not supported");
        QueryExecutors.onHive().executeQuery("DROP TABLE test_create_textfile_skip_footer", new QueryExecutor.QueryParam[0]);
    }
}

