/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hudi;

import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestHudiHiveTablesCompatibility
extends ProductTest {
    @Test(groups={"hudi", "profile_specific_tests"})
    public void testHudiSelectFromHiveTable() {
        String tableName = "test_hudi_select_from_hive_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE hive.default." + tableName + "(a bigint)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM hudi.default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q Not a Hudi table: default." + tableName);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM hudi.default.\"" + tableName + "$data\"", new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q line 1:15: Table 'hudi.default.\"" + tableName + "$data\"' does not exist");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM hudi.default.\"" + tableName + "$timeline\"", new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q line 1:15: Table 'hudi.default.\"" + tableName + "$timeline\"' does not exist");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM hudi.default.\"" + tableName + "$files\"", new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q Invalid Hudi table name (unknown type 'files'): " + tableName + "$files");
        QueryExecutors.onTrino().executeQuery("DROP TABLE hive.default." + tableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hudi", "profile_specific_tests"})
    public void testHiveSelectFromHudiTable() {
        String tableName = "test_hive_select_from_hudi_" + TestingNames.randomNameSuffix();
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CREATE TABLE hudi.default." + tableName + "(a bigint)", new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q This connector does not support creating tables");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM hive.default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageMatching(String.format("Query failed \\(#\\w+\\):\\Q line 1:15: Table 'hive.default.%s' does not exist", tableName));
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM hive.default.\"" + tableName + "$partitions\"", new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q line 1:15: Table 'hive.default.\"" + tableName + "$partitions\"' does not exist");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM hive.default.\"" + tableName + "$properties\"", new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q Table 'default." + tableName + "$properties' not found");
    }

    @Test(groups={"hudi", "profile_specific_tests"})
    public void testHudiCannotCreateTableNamesakeToHiveTable() {
        String tableName = "test_hudi_create_namesake_hive_table_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE hive.default." + tableName + "(a bigint)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CREATE TABLE hudi.default." + tableName + "(a bigint)", new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q line 1:1: Table 'hudi.default." + tableName + "' of unsupported type already exists");
        QueryExecutors.onTrino().executeQuery("DROP TABLE hive.default." + tableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hudi", "profile_specific_tests"})
    public void testHiveCannotCreateTableNamesakeToHudiTable() {
        String tableName = "test_hive_create_namesake_hudi_table_" + TestingNames.randomNameSuffix();
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CREATE TABLE hudi.default." + tableName + "(a bigint)", new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q This connector does not support creating tables");
    }

    @Test(groups={"hudi", "profile_specific_tests"})
    public void testHiveSelectTableColumns() {
        String hiveTableName = "test_hive_table_columns_table_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE hive.default." + hiveTableName + "(a bigint)", new QueryExecutor.QueryParam[0]);
        String hudiTableName = "test_hudi_table_columns_table_" + TestingNames.randomNameSuffix();
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CREATE TABLE hudi.default." + hudiTableName + "(a bigint)", new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q This connector does not support creating tables");
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT table_cat, table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_cat = 'hive' AND table_schem = 'default' AND table_name = '%s'", hiveTableName), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive", "default", hiveTableName, "a"})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT table_cat, table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_cat = 'hive' AND table_schem = 'default' AND table_name = '%s'", hudiTableName), new QueryExecutor.QueryParam[0]))).hasNoRows();
        QueryExecutors.onTrino().executeQuery("DROP TABLE hive.default." + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hudi", "profile_specific_tests"})
    public void testHiveListsHudiTable() {
        String tableName = "test_hive_lists_hudi_table_" + TestingNames.randomNameSuffix();
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CREATE TABLE hudi.default." + tableName + "(a bigint)", new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q This connector does not support creating tables");
        Assertions.assertThat((List)QueryExecutors.onTrino().executeQuery("SHOW TABLES FROM hive.default", new QueryExecutor.QueryParam[0]).column(1)).doesNotContain(new Object[]{tableName});
    }

    @Test(groups={"hudi", "profile_specific_tests"})
    public void testHudiListsHiveTable() {
        String tableName = "test_hudi_lists_hive_table_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE hive.default." + tableName + "(a bigint)", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW TABLES FROM hudi.default", new QueryExecutor.QueryParam[0]))).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{tableName})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE hive.default." + tableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hudi", "profile_specific_tests"})
    public void testHudiSelectFromHiveView() {
        String tableName = "hudi_from_hive_table_" + TestingNames.randomNameSuffix();
        String viewName = "hudi_from_trino_hive_view_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE TABLE hive.default." + tableName + " AS SELECT 1 a", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE VIEW hive.default." + viewName + " AS TABLE hive.default." + tableName, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM hudi.default." + viewName, new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q Not a Hudi table: default." + viewName);
        QueryExecutors.onTrino().executeQuery("DROP VIEW hive.default." + viewName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP TABLE hive.default." + tableName, new QueryExecutor.QueryParam[0]);
    }
}

