/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.iceberg;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestIcebergFormatVersionCompatibility
extends ProductTest {
    @Test(groups={"iceberg_format_version_compatibility", "profile_specific_tests"})
    public void testTrinoTimeTravelReadTableCreatedByEarlyVersionTrino() {
        String baseTableName = "test_trino_time_travel_read_table_created_by_early_version_trino_" + TestingNames.randomNameSuffix();
        String tableName = String.format("iceberg.default.%s", baseTableName);
        String snapshotsTableName = String.format("iceberg.default.\"%s$snapshots\"", baseTableName);
        QueryExecutors.onCompatibilityTestServer().executeQuery(String.format("CREATE TABLE %s (c VARCHAR)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onCompatibilityTestServer().executeQuery(String.format("INSERT INTO %s VALUES 'a', 'b', 'c';", tableName), new QueryExecutor.QueryParam[0]);
        long latestSnapshotId = (Long)QueryExecutors.onCompatibilityTestServer().executeQuery(String.format("SELECT snapshot_id FROM %s ORDER BY committed_at DESC FETCH FIRST 1 ROW WITH TIES", snapshotsTableName), new QueryExecutor.QueryParam[0]).getOnlyValue();
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT snapshot_id FROM %s ORDER BY committed_at DESC FETCH FIRST 1 ROW WITH TIES", snapshotsTableName), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{latestSnapshotId})});
        List expected = (List)QueryExecutors.onCompatibilityTestServer().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0]).rows().stream().map(row -> QueryAssert.Row.row((Object[])row.toArray())).collect(ImmutableList.toImmutableList());
        Assertions.assertThat((int)expected.size()).isEqualTo(3);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s FOR VERSION AS OF %d", tableName, latestSnapshotId), new QueryExecutor.QueryParam[0]))).containsOnly(expected);
        QueryExecutors.onCompatibilityTestServer().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }
}

