/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.iceberg;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.AfterMethodWithContext;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestIcebergHiveMetadataListing
extends ProductTest {
    private List<QueryAssert.Row> preexistingTables;
    private List<QueryAssert.Row> preexistingColumns;

    @BeforeMethodWithContext
    public void setUp() {
        this.cleanUp();
        this.preexistingTables = QueryExecutors.onTrino().executeQuery("SHOW TABLES FROM iceberg.default", new QueryExecutor.QueryParam[0]).rows().stream().map(list -> QueryAssert.Row.row((Object[])list.toArray())).collect(Collectors.toList());
        this.preexistingColumns = QueryExecutors.onTrino().executeQuery("SELECT table_name, column_name FROM iceberg.information_schema.columns WHERE table_catalog = 'iceberg' AND table_schema = 'default'", new QueryExecutor.QueryParam[0]).rows().stream().map(list -> QueryAssert.Row.row((Object[])list.toArray())).collect(Collectors.toList());
        QueryExecutors.onTrino().executeQuery("CREATE TABLE iceberg.default.iceberg_table1 (_string VARCHAR, _integer INTEGER)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE MATERIALIZED VIEW iceberg.default.iceberg_materialized_view AS SELECT * FROM iceberg.default.iceberg_table1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE hive.default.hive_table (_double DOUBLE)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE VIEW hive.default.hive_view AS SELECT * FROM hive.default.hive_table", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE VIEW iceberg.default.iceberg_view AS SELECT * FROM iceberg.default.iceberg_table1", new QueryExecutor.QueryParam[0]);
    }

    @AfterMethodWithContext
    public void cleanUp() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS hive.default.hive_table", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP VIEW IF EXISTS hive.default.hive_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP VIEW IF EXISTS iceberg.default.iceberg_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP MATERIALIZED VIEW IF EXISTS iceberg.default.iceberg_materialized_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS iceberg.default.iceberg_table1", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "storage_formats", "hms_only"})
    public void testTableListing() {
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW TABLES FROM iceberg.default", new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.builder().addAll(this.preexistingTables).add((Object)QueryAssert.Row.row((Object[])new Object[]{"iceberg_table1"})).add((Object)QueryAssert.Row.row((Object[])new Object[]{"iceberg_materialized_view"})).add((Object)QueryAssert.Row.row((Object[])new Object[]{"iceberg_view"})).add((Object)QueryAssert.Row.row((Object[])new Object[]{"hive_table"})).add((Object)QueryAssert.Row.row((Object[])new Object[]{"hive_view"})).build());
    }

    @Test(groups={"iceberg", "storage_formats", "hms_only"})
    public void testColumnListing() {
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT table_name, column_name FROM iceberg.information_schema.columns WHERE table_catalog = 'iceberg' AND table_schema = 'default'", new QueryExecutor.QueryParam[0]))).containsOnly((List)ImmutableList.builder().addAll(this.preexistingColumns).add((Object)QueryAssert.Row.row((Object[])new Object[]{"iceberg_table1", "_string"})).add((Object)QueryAssert.Row.row((Object[])new Object[]{"iceberg_table1", "_integer"})).add((Object)QueryAssert.Row.row((Object[])new Object[]{"iceberg_materialized_view", "_string"})).add((Object)QueryAssert.Row.row((Object[])new Object[]{"iceberg_materialized_view", "_integer"})).add((Object)QueryAssert.Row.row((Object[])new Object[]{"iceberg_view", "_string"})).add((Object)QueryAssert.Row.row((Object[])new Object[]{"iceberg_view", "_integer"})).add((Object)QueryAssert.Row.row((Object[])new Object[]{"hive_view", "_double"})).build());
    }
}

