/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.iceberg;

import io.trino.jdbc.Row;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestIcebergPartitionEvolution
extends ProductTest {
    @Test(groups={"iceberg", "profile_specific_tests"}, dataProvider="testDroppedPartitionFieldDataProvider")
    public void testDroppedPartitionField(boolean dropFirst) {
        QueryExecutors.onTrino().executeQuery("USE iceberg.default", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS test_dropped_partition_field", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE test_dropped_partition_field(a varchar, b varchar, c varchar) WITH (format_version = 1, partitioning = ARRAY['a','b'])", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO test_dropped_partition_field VALUES ('one', 'small', 'snake'),('one', 'small', 'rabbit'),('one', 'big', 'rabbit'),('another', 'small', 'snake'),('something', 'completely', 'else'),(NULL, NULL, 'nothing')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onSpark().executeQuery("ALTER TABLE iceberg_test.default.test_dropped_partition_field DROP PARTITION FIELD " + (dropFirst ? "a" : "b"), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)((String)QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE test_dropped_partition_field", new QueryExecutor.QueryParam[0]).getOnlyValue())).matches((CharSequence)("\\QCREATE TABLE iceberg.default.test_dropped_partition_field (\n   a varchar,\n   b varchar,\n   c varchar\n)\nWITH (\n   format = 'PARQUET',\n   format_version = 1,\n   location = 'hdfs://hadoop-master:9000/user/hive/warehouse/test_dropped_partition_field-\\E.*\\Q',\n   partitioning = ARRAY[" + (dropFirst ? "'void(a)','b'" : "'a','void(b)'") + "]\n)\\E"));
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM test_dropped_partition_field", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"one", "small", "snake"}), QueryAssert.Row.row((Object[])new Object[]{"one", "small", "rabbit"}), QueryAssert.Row.row((Object[])new Object[]{"one", "big", "rabbit"}), QueryAssert.Row.row((Object[])new Object[]{"another", "small", "snake"}), QueryAssert.Row.row((Object[])new Object[]{"something", "completely", "else"}), QueryAssert.Row.row((Object[])new Object[]{null, null, "nothing"})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR test_dropped_partition_field", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"a", 599.0, 3.0, 0.16666666666666666, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"b", 602.0, 3.0, 0.16666666666666666, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c", 585.0, 4.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 6.0, null, null})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT column_name, data_type FROM information_schema.columns WHERE table_name = 'test_dropped_partition_field$partitions'", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"partition", "row(a varchar, b varchar)"}), QueryAssert.Row.row((Object[])new Object[]{"record_count", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"file_count", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"total_size", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"data", "row(" + (dropFirst ? "a" : "b") + " row(min varchar, max varchar, null_count bigint, nan_count bigint), c row(min varchar, max varchar, null_count bigint, nan_count bigint))"})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT partition, record_count, file_count, data FROM \"test_dropped_partition_field$partitions\"", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{TestIcebergPartitionEvolution.rowBuilder().addField("a", (Object)"one").addField("b", (Object)"small").build(), 2L, 1L, TestIcebergPartitionEvolution.rowBuilder().addField(dropFirst ? "a" : "b", (Object)(dropFirst ? TestIcebergPartitionEvolution.singletonMetrics("one") : TestIcebergPartitionEvolution.singletonMetrics("small"))).addField("c", (Object)TestIcebergPartitionEvolution.dataMetrics("rabbit", "snake", 0L, null)).build()}), QueryAssert.Row.row((Object[])new Object[]{TestIcebergPartitionEvolution.rowBuilder().addField("a", (Object)"one").addField("b", (Object)"big").build(), 1L, 1L, TestIcebergPartitionEvolution.rowBuilder().addField(dropFirst ? "a" : "b", (Object)(dropFirst ? TestIcebergPartitionEvolution.singletonMetrics("one") : TestIcebergPartitionEvolution.singletonMetrics("big"))).addField("c", (Object)TestIcebergPartitionEvolution.singletonMetrics("rabbit")).build()}), QueryAssert.Row.row((Object[])new Object[]{TestIcebergPartitionEvolution.rowBuilder().addField("a", (Object)"another").addField("b", (Object)"small").build(), 1L, 1L, TestIcebergPartitionEvolution.rowBuilder().addField(dropFirst ? "a" : "b", (Object)(dropFirst ? TestIcebergPartitionEvolution.singletonMetrics("another") : TestIcebergPartitionEvolution.singletonMetrics("small"))).addField("c", (Object)TestIcebergPartitionEvolution.singletonMetrics("snake")).build()}), QueryAssert.Row.row((Object[])new Object[]{TestIcebergPartitionEvolution.rowBuilder().addField("a", (Object)"something").addField("b", (Object)"completely").build(), 1L, 1L, TestIcebergPartitionEvolution.rowBuilder().addField(dropFirst ? "a" : "b", (Object)(dropFirst ? TestIcebergPartitionEvolution.singletonMetrics("something") : TestIcebergPartitionEvolution.singletonMetrics("completely"))).addField("c", (Object)TestIcebergPartitionEvolution.singletonMetrics("else")).build()}), QueryAssert.Row.row((Object[])new Object[]{TestIcebergPartitionEvolution.rowBuilder().addField("a", null).addField("b", null).build(), 1L, 1L, TestIcebergPartitionEvolution.rowBuilder().addField(dropFirst ? "a" : "b", (Object)TestIcebergPartitionEvolution.dataMetrics(null, null, 1L, null)).addField("c", (Object)TestIcebergPartitionEvolution.singletonMetrics("nothing")).build()})});
        QueryExecutors.onTrino().executeQuery("INSERT INTO test_dropped_partition_field VALUES ('yet', 'another', 'row')", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM test_dropped_partition_field", new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"one", "small", "snake"}), QueryAssert.Row.row((Object[])new Object[]{"one", "small", "rabbit"}), QueryAssert.Row.row((Object[])new Object[]{"one", "big", "rabbit"}), QueryAssert.Row.row((Object[])new Object[]{"another", "small", "snake"}), QueryAssert.Row.row((Object[])new Object[]{"something", "completely", "else"}), QueryAssert.Row.row((Object[])new Object[]{null, null, "nothing"}), QueryAssert.Row.row((Object[])new Object[]{"yet", "another", "row"})});
    }

    @DataProvider
    public Object[][] testDroppedPartitionFieldDataProvider() {
        return new Object[][]{{true}, {false}};
    }

    private static Row singletonMetrics(Object value) {
        return TestIcebergPartitionEvolution.dataMetrics(value, value, 0L, null);
    }

    private static Row dataMetrics(Object min, Object max, long nullCount, Long nanCount) {
        return TestIcebergPartitionEvolution.rowBuilder().addField("min", min).addField("max", max).addField("null_count", (Object)nullCount).addField("nan_count", (Object)nanCount).build();
    }

    private static Row.Builder rowBuilder() {
        return Row.builder();
    }
}

