/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.iceberg;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testing.TestingNames;
import io.trino.tests.product.hive.util.TableLocationUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import java.util.function.Consumer;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestIcebergProcedureCalls
extends ProductTest {
    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testMigrateHiveTable() {
        String tableName = "test_migrate_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        String sparkTableName = "iceberg_test.default." + tableName;
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + hiveTableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + hiveTableName + " AS SELECT 1 x", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CALL iceberg.system.migrate('default', '" + tableName + "')", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + icebergTableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onSpark().executeQuery("SELECT * FROM " + sparkTableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "profile_specific_tests"}, dataProvider="fileFormats")
    public void testMigrateHiveTableWithTinyintType(String fileFormat) {
        String tableName = "test_migrate_tinyint" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        String sparkTableName = "iceberg_test.default." + tableName;
        String createTable = "CREATE TABLE " + hiveTableName + "(col TINYINT) WITH (format = '" + fileFormat + "')";
        if (fileFormat.equals("AVRO")) {
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(createTable, new QueryExecutor.QueryParam[0])).hasMessageContaining("Column 'col' is tinyint, which is not supported by Avro. Use integer instead.");
            return;
        }
        QueryExecutors.onTrino().executeQuery(createTable, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + hiveTableName + " VALUES -128, 127", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CALL iceberg.system.migrate('default', '" + tableName + "')", new QueryExecutor.QueryParam[0]);
        ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{-128}), (Object)QueryAssert.Row.row((Object[])new Object[]{127}));
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + icebergTableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expected);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onSpark().executeQuery("SELECT * FROM " + sparkTableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expected);
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "profile_specific_tests"}, dataProvider="fileFormats")
    public void testMigrateHiveTableWithSmallintType(String fileFormat) {
        String tableName = "test_migrate_smallint" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        String sparkTableName = "iceberg_test.default." + tableName;
        String createTable = "CREATE TABLE " + hiveTableName + "(col SMALLINT) WITH (format = '" + fileFormat + "')";
        if (fileFormat.equals("AVRO")) {
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(createTable, new QueryExecutor.QueryParam[0])).hasMessageContaining("Column 'col' is smallint, which is not supported by Avro. Use integer instead.");
            return;
        }
        QueryExecutors.onTrino().executeQuery(createTable, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + hiveTableName + " VALUES -32768, 32767", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CALL iceberg.system.migrate('default', '" + tableName + "')", new QueryExecutor.QueryParam[0]);
        ImmutableList expected = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{Short.MIN_VALUE}), (Object)QueryAssert.Row.row((Object[])new Object[]{Short.MAX_VALUE}));
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + icebergTableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expected);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onSpark().executeQuery("SELECT * FROM " + sparkTableName, new QueryExecutor.QueryParam[0]))).containsOnly((List)expected);
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "profile_specific_tests"}, dataProvider="fileFormats")
    public void testMigrateHiveTableWithComplexType(String fileFormat) {
        String tableName = "test_migrate_complex_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        String sparkTableName = "iceberg_test.default." + tableName;
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + hiveTableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + hiveTableName + " WITH (format='" + fileFormat + "') AS SELECT 1 x, array[2, 3] a, CAST(map(array['key'], array['value']) AS map(varchar, varchar)) b, CAST(row(1) AS row(d integer)) c", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CALL iceberg.system.migrate('default', '" + tableName + "')", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT x, a[1], a[2], b['key'], c.d FROM " + icebergTableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 2, 3, "value", 1})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onSpark().executeQuery("SELECT x, element_at(a, 1), element_at(a, 2), element_at(b, 'key'), c.d FROM " + sparkTableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 2, 3, "value", 1})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testMigrateHivePartitionedTable() {
        String tableName = "test_migrate_partitioned_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        String sparkTableName = "iceberg_test.default." + tableName;
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + hiveTableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + hiveTableName + " WITH (partitioned_by = ARRAY['part']) AS SELECT 1 x, 'test' part", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CALL iceberg.system.migrate('default', '" + tableName + "')", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + icebergTableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "test"})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onSpark().executeQuery("SELECT * FROM " + sparkTableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "test"})});
        Assertions.assertThat((String)((String)QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]).getOnlyValue())).contains(new CharSequence[]{"partitioning = ARRAY['part']"});
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testMigrateHiveBucketedTable() {
        String tableName = "test_migrate_bucketed_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        String sparkTableName = "iceberg_test.default." + tableName;
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + hiveTableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + hiveTableName + " WITH (partitioned_by = ARRAY['part'], bucketed_by = ARRAY['bucket'], bucket_count = 10)AS SELECT 1 bucket, 'test' part", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CALL iceberg.system.migrate('default', '" + tableName + "')", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + icebergTableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "test"})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onSpark().executeQuery("SELECT * FROM " + sparkTableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "test"})});
        Assertions.assertThat((String)((String)QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]).getOnlyValue())).contains(new CharSequence[]{"partitioning = ARRAY['part']"});
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testMigrateHiveBucketedOnMultipleColumns() {
        String tableName = "test_migrate_bucketed_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        String sparkTableName = "iceberg_test.default." + tableName;
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + hiveTableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + hiveTableName + " WITH (partitioned_by = ARRAY['part'], bucketed_by = ARRAY['bucket', 'another_bucket'], bucket_count = 10)AS SELECT 1 bucket, 'a' another_bucket, 'test' part", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CALL iceberg.system.migrate('default', '" + tableName + "')", new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + icebergTableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "a", "test"})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onSpark().executeQuery("SELECT * FROM " + sparkTableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "a", "test"})});
        Assertions.assertThat((String)((String)QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]).getOnlyValue())).contains(new CharSequence[]{"partitioning = ARRAY['part']"});
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testTrinoMigrateExternalTable() {
        this.migrateExternalTable(tableName -> QueryExecutors.onTrino().executeQuery("CALL iceberg.system.migrate('default', '" + tableName + "')", new QueryExecutor.QueryParam[0]));
    }

    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testSparkMigrateExternalTable() {
        this.migrateExternalTable(tableName -> QueryExecutors.onSpark().executeQuery("CALL iceberg_test.system.migrate('default." + tableName + "')", new QueryExecutor.QueryParam[0]));
    }

    private void migrateExternalTable(Consumer<String> migrateTable) {
        String managedTableName = "test_migrate_managed_" + TestingNames.randomNameSuffix();
        String externalTableName = "test_migrate_external_" + TestingNames.randomNameSuffix();
        String icebergTableName = "iceberg.default." + externalTableName;
        String sparkTableName = "iceberg_test.default." + externalTableName;
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS hive.default." + managedTableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE hive.default." + managedTableName + " AS SELECT 1 x", new QueryExecutor.QueryParam[0]);
        String tableLocation = TableLocationUtils.getTableLocation("hive.default." + managedTableName);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE hive.default." + externalTableName + "(x integer) WITH (external_location = '" + tableLocation + "')", new QueryExecutor.QueryParam[0]);
        migrateTable.accept(externalTableName);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + icebergTableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onSpark().executeQuery("SELECT * FROM " + sparkTableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM hive.default." + managedTableName, new QueryExecutor.QueryParam[0])).hasMessageContaining("Partition location does not exist");
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onHive().executeQuery("SELECT * FROM default." + managedTableName, new QueryExecutor.QueryParam[0]))).hasNoRows();
        QueryExecutors.onTrino().executeQuery("DROP TABLE hive.default." + managedTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testMigrateUnsupportedTransactionalTable() {
        String tableName = "test_migrate_unsupported_transactional_table_" + TestingNames.randomNameSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + hiveTableName + " WITH (transactional = true) AS SELECT 1 x", new QueryExecutor.QueryParam[0]);
        Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("CALL iceberg.system.migrate('default', '" + tableName + "')", new QueryExecutor.QueryParam[0])).hasMessageContaining("Migrating transactional tables is unsupported");
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + hiveTableName, new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
        Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM " + icebergTableName, new QueryExecutor.QueryParam[0])).hasMessageContaining("Not an Iceberg table");
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testRollbackToSnapshot() throws InterruptedException {
        String tableName = "test_rollback_to_snapshot_" + TestingNames.randomNameSuffix();
        QueryExecutors.onTrino().executeQuery("USE iceberg.default", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (a INTEGER)", tableName), new QueryExecutor.QueryParam[0]);
        Thread.sleep(1L);
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES 1", tableName), new QueryExecutor.QueryParam[0]);
        Thread.sleep(1L);
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES 2", tableName), new QueryExecutor.QueryParam[0]);
        long snapshotId = this.getSecondOldestTableSnapshot(tableName);
        QueryExecutors.onTrino().executeQuery(String.format("call system.rollback_to_snapshot('default', '%s', %d)", tableName, snapshotId), new QueryExecutor.QueryParam[0]);
        ((QueryAssert)Assertions.assertThat((AssertProvider)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0]))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testRollbackToSnapshotWithNullArgument() {
        QueryExecutors.onTrino().executeQuery("USE iceberg.default", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CALL system.rollback_to_snapshot(NULL, 'customer_orders', 8954597067493422955)", new QueryExecutor.QueryParam[0])).hasMessageMatching(".*schema cannot be null.*");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CALL system.rollback_to_snapshot('testdb', NULL, 8954597067493422955)", new QueryExecutor.QueryParam[0])).hasMessageMatching(".*table cannot be null.*");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CALL system.rollback_to_snapshot('testdb', 'customer_orders', NULL)", new QueryExecutor.QueryParam[0])).hasMessageMatching(".*snapshot_id cannot be null.*");
    }

    private long getSecondOldestTableSnapshot(String tableName) {
        return (Long)QueryExecutors.onTrino().executeQuery(String.format("SELECT snapshot_id FROM iceberg.default.\"%s$snapshots\" WHERE parent_id IS NOT NULL ORDER BY committed_at FETCH FIRST 1 ROW WITH TIES", tableName), new QueryExecutor.QueryParam[0]).getOnlyValue();
    }

    @DataProvider
    public static Object[][] fileFormats() {
        return new Object[][]{{"ORC"}, {"PARQUET"}, {"AVRO"}};
    }
}

