/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.iceberg.util;

import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import java.net.URI;

public final class IcebergTestUtils {
    private IcebergTestUtils() {
    }

    public static String getTableLocation(String tableName) {
        return (String)QueryExecutors.onTrino().executeQuery("SELECT DISTINCT regexp_replace(\"$path\", '/[^/]*/[^/]*$', '') FROM " + tableName, new QueryExecutor.QueryParam[0]).getOnlyValue();
    }

    public static String getLatestMetadataFilename(String catalog, String schema, String tableName) {
        return (String)QueryExecutors.onTrino().executeQuery("SELECT substring(file, strpos(file, '/', -1) + 1) FROM %s.%s.\"%s$metadata_log_entries\" ORDER BY timestamp DESC LIMIT 1".formatted(catalog, schema, tableName), new QueryExecutor.QueryParam[0]).getOnlyValue();
    }

    public static String stripNamenodeURI(String location) {
        return URI.create(location).getPath();
    }
}

