/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.jdbc;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.ProductTest;
import io.trino.tempto.Requirement;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.ImmutableLdapObjectDefinitions;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;

public abstract class BaseLdapJdbcTest
extends ProductTest
implements RequirementsProvider {
    protected static final long TIMEOUT = 30000L;
    protected static final String NATION_SELECT_ALL_QUERY = "SELECT * FROM tpch.tiny.nation";
    @Inject
    @Named(value="databases.presto.cli_ldap_truststore_path")
    protected String ldapTruststorePath;
    @Inject
    @Named(value="databases.presto.cli_ldap_truststore_password")
    protected String ldapTruststorePassword;
    @Inject
    @Named(value="databases.presto.cli_ldap_user_name")
    protected String ldapUserName;
    @Inject
    @Named(value="databases.presto.cli_ldap_user_password")
    protected String ldapUserPassword;
    @Inject
    @Named(value="databases.presto.cli_ldap_server_address")
    private String prestoServer;

    public Requirement getRequirements(Configuration configuration) {
        return ImmutableLdapObjectDefinitions.getLdapRequirement();
    }

    protected void expectQueryToFail(String user, String password, String message) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.executeLdapQuery(NATION_SELECT_ALL_QUERY, user, password)).isInstanceOf(SQLException.class)).hasMessageContaining(message);
    }

    protected QueryResult executeLdapQuery(String query, String name, String password) throws SQLException {
        try (Connection connection = this.getLdapConnection(name, password);){
            Statement statement = connection.createStatement();
            ResultSet rs = statement.executeQuery(query);
            QueryResult queryResult = QueryResult.forResultSet((ResultSet)rs);
            return queryResult;
        }
    }

    private Connection getLdapConnection(String name, String password) throws SQLException {
        return DriverManager.getConnection(this.getLdapUrl(), name, password);
    }

    protected String prestoServer() {
        String prefix = "https://";
        Preconditions.checkState((boolean)this.prestoServer.startsWith(prefix), (String)"invalid server address: %s", (Object)this.prestoServer);
        return this.prestoServer.substring(prefix.length());
    }

    protected String getLdapUrl() {
        return String.format(this.getLdapUrlFormat(), this.prestoServer(), this.ldapTruststorePath, this.ldapTruststorePassword);
    }

    protected abstract String getLdapUrlFormat();
}

