/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.jdbc;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.BeforeMethodWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.kerberos.KerberosAuthentication;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.TpchTableResults;
import java.security.Principal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.security.auth.Subject;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.testng.annotations.Test;

public class TestKerberosConstrainedDelegationJdbc
extends ProductTest {
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";
    @Inject
    @Named(value="databases.presto.jdbc_url")
    String jdbcUrl;
    @Inject
    @Named(value="databases.presto.kerberos_principal")
    private String kerberosPrincipal;
    @Inject
    @Named(value="databases.presto.kerberos_keytab")
    private String kerberosKeytab;
    private GSSManager gssManager;
    private KerberosAuthentication kerberosAuthentication;

    @BeforeMethodWithContext
    public void setUp() {
        this.gssManager = GSSManager.getInstance();
        this.kerberosAuthentication = new KerberosAuthentication(this.kerberosPrincipal, this.kerberosKeytab);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"jdbc_kerberos_constrained_delegation"})
    public void testSelectConstrainedDelegationKerberos() throws Exception {
        Properties driverProperties = new Properties();
        GSSCredential credential = this.createGssCredential();
        driverProperties.put("KerberosConstrainedDelegation", credential);
        try (Connection connection = DriverManager.getConnection(this.jdbcUrl, driverProperties);
             PreparedStatement statement = connection.prepareStatement("SELECT * FROM tpch.tiny.nation");
             ResultSet results = statement.executeQuery();){
            ((QueryAssert)Assertions.assertThat((AssertProvider)QueryResult.forResultSet((ResultSet)results))).matches(TpchTableResults.PRESTO_NATION_RESULT);
        }
        finally {
            credential.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"jdbc_kerberos_constrained_delegation"})
    public void testCtasConstrainedDelegationKerberos() throws Exception {
        Properties driverProperties = new Properties();
        GSSCredential credential = this.createGssCredential();
        driverProperties.put("KerberosConstrainedDelegation", credential);
        try (Connection connection = DriverManager.getConnection(this.jdbcUrl, driverProperties);
             PreparedStatement statement = connection.prepareStatement(String.format("CREATE TABLE %s AS SELECT * FROM tpch.tiny.nation", "test_kerberos_ctas"));){
            int results = statement.executeUpdate();
            Assertions.assertThat((int)results).isEqualTo(25);
        }
        finally {
            credential.dispose();
        }
    }

    @Test(groups={"jdbc_kerberos_constrained_delegation"})
    public void testQueryOnDisposedCredential() throws Exception {
        Properties driverProperties = new Properties();
        GSSCredential credential = this.createGssCredential();
        credential.dispose();
        driverProperties.put("KerberosConstrainedDelegation", credential);
        try (Connection connection = DriverManager.getConnection(this.jdbcUrl, driverProperties);){
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> connection.prepareStatement("SELECT * FROM tpch.tiny.nation")).cause().isInstanceOf(IllegalStateException.class)).hasMessageContaining("This credential is no longer valid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"jdbc_kerberos_constrained_delegation"})
    public void testQueryOnExpiredCredential() throws Exception {
        Properties driverProperties = new Properties();
        GSSCredential credential = this.createGssCredential();
        Thread.sleep(30000L);
        Assertions.assertThat((int)credential.getRemainingLifetime()).isLessThanOrEqualTo(60);
        driverProperties.put("KerberosConstrainedDelegation", credential);
        try (Connection connection = DriverManager.getConnection(this.jdbcUrl, driverProperties);){
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> connection.prepareStatement("SELECT * FROM tpch.tiny.nation")).isInstanceOf(SQLException.class)).hasMessageContaining("Kerberos credential is expired");
        }
        finally {
            credential.dispose();
        }
    }

    private GSSCredential createGssCredential() {
        Subject authenticatedSubject = this.kerberosAuthentication.authenticate();
        Principal clientPrincipal = (Principal)Iterables.getOnlyElement(authenticatedSubject.getPrincipals());
        return Subject.callAs(authenticatedSubject, () -> this.gssManager.createCredential(this.gssManager.createName(clientPrincipal.getName(), GSSName.NT_USER_NAME), 0, new Oid(KERBEROS_OID), 1));
    }
}

