/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.utils;

import com.google.common.collect.Iterables;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;

public final class CachingTestUtils {
    private CachingTestUtils() {
    }

    public static CacheStats getCacheStats(String catalog) {
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery("SELECT   sum(\"cachereads.alltime.count\") as cachereads,   sum(\"externalreads.alltime.count\") as externalreads FROM jmx.current.\"io.trino.filesystem.alluxio:name=" + catalog + ",type=alluxiocachestats\";", new QueryExecutor.QueryParam[0]);
        double cacheReads = (Double)((List)Iterables.getOnlyElement((Iterable)queryResult.rows())).get((Integer)queryResult.tryFindColumnIndex("cachereads").get() - 1);
        double externalReads = (Double)((List)Iterables.getOnlyElement((Iterable)queryResult.rows())).get((Integer)queryResult.tryFindColumnIndex("externalreads").get() - 1);
        long cacheSpaceUsed = (Long)QueryExecutors.onTrino().executeQuery("SELECT sum(count) FROM jmx.current.\"org.alluxio:name=client.cachespaceusedcount,type=counters\"", new QueryExecutor.QueryParam[0]).getOnlyValue();
        return new CacheStats(cacheReads, externalReads, cacheSpaceUsed);
    }

    public record CacheStats(double cacheReads, double externalReads, long cacheSpaceUsed) {
    }
}

