/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.utils;

import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import io.airlift.log.Logger;
import io.trino.tempto.context.ThreadLocalTestContextHolder;
import io.trino.tempto.query.QueryExecutionException;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.utils.HadoopTestUtils;
import java.sql.Connection;
import java.time.temporal.ChronoUnit;

public final class QueryExecutors {
    private static final Logger log = Logger.get(QueryExecutors.class);

    public static QueryExecutor onTrino() {
        return QueryExecutors.connectToTrino("presto");
    }

    public static QueryExecutor onCompatibilityTestServer() {
        return QueryExecutors.connectToTrino("compatibility-test-server");
    }

    public static QueryExecutor connectToTrino(final String trinoConfig) {
        return new QueryExecutor(){
            private final QueryExecutor delegate;
            {
                this.delegate = (QueryExecutor)ThreadLocalTestContextHolder.testContext().getDependency(QueryExecutor.class, trinoConfig);
            }

            public QueryResult executeQuery(String sql, QueryExecutor.QueryParam ... params) throws QueryExecutionException {
                return (QueryResult)Failsafe.with(HadoopTestUtils.ERROR_COMMITTING_WRITE_TO_HIVE_RETRY_POLICY, (Policy[])new RetryPolicy[0]).get(() -> this.delegate.executeQuery(sql, params));
            }

            public Connection getConnection() {
                return this.delegate.getConnection();
            }

            public void close() {
                this.delegate.close();
            }
        };
    }

    public static QueryExecutor onExasol() {
        return (QueryExecutor)ThreadLocalTestContextHolder.testContext().getDependency(QueryExecutor.class, "exasol");
    }

    public static QueryExecutor onHive() {
        return (QueryExecutor)ThreadLocalTestContextHolder.testContext().getDependency(QueryExecutor.class, "hive");
    }

    public static QueryExecutor onSqlServer() {
        return (QueryExecutor)ThreadLocalTestContextHolder.testContext().getDependency(QueryExecutor.class, "sqlserver");
    }

    public static QueryExecutor onMySql() {
        return (QueryExecutor)ThreadLocalTestContextHolder.testContext().getDependency(QueryExecutor.class, "mysql");
    }

    public static QueryExecutor onSpark() {
        return new QueryExecutor(){
            private final QueryExecutor delegate = (QueryExecutor)ThreadLocalTestContextHolder.testContext().getDependency(QueryExecutor.class, "spark");

            public QueryResult executeQuery(String sql, QueryExecutor.QueryParam ... params) throws QueryExecutionException {
                return (QueryResult)Failsafe.with(HadoopTestUtils.ERROR_COMMITTING_WRITE_TO_HIVE_RETRY_POLICY, (Policy[])new RetryPolicy[0]).get(() -> this.delegate.executeQuery(sql, params));
            }

            public Connection getConnection() {
                return this.delegate.getConnection();
            }

            public void close() {
                this.delegate.close();
            }
        };
    }

    public static QueryExecutor onDelta() {
        final RetryPolicy databricksRetryPolicy = ((RetryPolicyBuilder)RetryPolicy.builder().handleIf(throwable -> throwable.getMessage().contains("HTTP Response code: 502"))).withBackoff(1L, 10L, ChronoUnit.SECONDS).withMaxRetries(60).onRetry(event -> log.warn(event.getLastException(), "Query failed on attempt %d, will retry.", new Object[]{event.getAttemptCount()})).build();
        return new QueryExecutor(){
            private final QueryExecutor delegate = (QueryExecutor)ThreadLocalTestContextHolder.testContext().getDependency(QueryExecutor.class, "delta");

            public QueryResult executeQuery(String sql, QueryExecutor.QueryParam ... params) throws QueryExecutionException {
                return (QueryResult)Failsafe.with((Policy)databricksRetryPolicy, (Policy[])new RetryPolicy[0]).get(() -> this.delegate.executeQuery(sql, params));
            }

            public Connection getConnection() {
                return this.delegate.getConnection();
            }

            public void close() {
                this.delegate.close();
            }
        };
    }

    public static QueryExecutor onHudi() {
        return (QueryExecutor)ThreadLocalTestContextHolder.testContext().getDependency(QueryExecutor.class, "hudi");
    }

    private QueryExecutors() {
    }
}

