/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs.tracing;

import io.airlift.jaxrs.tracing.TracingFilter;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;

public class TracingDynamicFeature
implements DynamicFeature {
    private final OpenTelemetry openTelemetry;
    private final Tracer tracer;

    @Inject
    public TracingDynamicFeature(OpenTelemetry openTelemetry, Tracer tracer) {
        this.openTelemetry = Objects.requireNonNull(openTelemetry, "openTelemetry is null");
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        context.register((Object)new TracingFilter(this.openTelemetry, this.tracer, resourceInfo.getResourceClass().getName(), resourceInfo.getResourceMethod().getName()));
    }
}

