/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.airlift.http.client.HeaderName;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import java.net.URI;
import java.util.List;
import javax.annotation.Nullable;

public class UnexpectedResponseException
extends RuntimeException {
    private final URI requestUri;
    private final String requestMethod;
    private final int statusCode;
    private final ListMultimap<HeaderName, String> headers;

    public UnexpectedResponseException(Request request, Response response) {
        this("HTTP " + response.getStatusCode(), request, response.getStatusCode(), (ListMultimap<HeaderName, String>)ImmutableListMultimap.copyOf(response.getHeaders()));
    }

    public UnexpectedResponseException(String message, Request request, Response response) {
        this(message, request, response.getStatusCode(), (ListMultimap<HeaderName, String>)ImmutableListMultimap.copyOf(response.getHeaders()));
    }

    public UnexpectedResponseException(String message, Request request, int statusCode, ListMultimap<HeaderName, String> headers) {
        super(message);
        this.requestUri = request != null ? request.getUri() : null;
        this.requestMethod = request != null ? request.getMethod() : null;
        this.statusCode = statusCode;
        this.headers = ImmutableListMultimap.copyOf(headers);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Nullable
    public String getHeader(String name) {
        List values = this.getHeaders().get((Object)HeaderName.of(name));
        return values.isEmpty() ? null : (String)values.get(0);
    }

    public List<String> getHeaders(String name) {
        return this.headers.get((Object)HeaderName.of(name));
    }

    public ListMultimap<HeaderName, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("request", (Object)(this.requestMethod + " " + this.requestUri)).add("statusCode", this.statusCode).add("headers", this.headers).toString();
    }
}

