/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.datamodel;

import java.util.Objects;
import org.openjdk.jol.datamodel.DataModel;

public class Model32
implements DataModel {
    private final int align;

    public Model32() {
        this(8);
    }

    public Model32(int align) {
        this.align = align;
    }

    @Override
    public int markHeaderSize() {
        return 4;
    }

    @Override
    public int classHeaderSize() {
        return 4;
    }

    @Override
    public int arrayLengthHeaderSize() {
        return 4;
    }

    @Override
    public int headerSize() {
        return this.markHeaderSize() + this.classHeaderSize();
    }

    @Override
    public int arrayHeaderSize() {
        return this.headerSize() + this.arrayLengthHeaderSize();
    }

    @Override
    public int sizeOf(String klass) {
        if (klass.equals("byte")) {
            return 1;
        }
        if (klass.equals("boolean")) {
            return 1;
        }
        if (klass.equals("short")) {
            return 2;
        }
        if (klass.equals("char")) {
            return 2;
        }
        if (klass.equals("int")) {
            return 4;
        }
        if (klass.equals("float")) {
            return 4;
        }
        if (klass.equals("long")) {
            return 8;
        }
        if (klass.equals("double")) {
            return 8;
        }
        return 4;
    }

    @Override
    public int objectAlignment() {
        return this.align;
    }

    public String toString() {
        return "32-bit model, " + this.align + "-byte aligned";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Model32 model32 = (Model32)o;
        return this.align == model32.align;
    }

    public int hashCode() {
        return Objects.hash(this.align);
    }
}

