/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal;

import com.google.common.annotations.VisibleForTesting;
import io.opentelemetry.exporter.internal.TlsUtil;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public class TlsConfigHelper {
    private static final Logger logger = Logger.getLogger(TlsConfigHelper.class.getName());
    private final TlsUtility tlsUtil;
    @Nullable
    private X509KeyManager keyManager;
    @Nullable
    private X509TrustManager trustManager;
    @Nullable
    private SSLSocketFactory sslSocketFactory;

    public TlsConfigHelper() {
        this(new TlsUtility(){});
    }

    @VisibleForTesting
    TlsConfigHelper(TlsUtility tlsUtil) {
        this.tlsUtil = tlsUtil;
    }

    public TlsConfigHelper setTrustManager(X509TrustManager trustManager) {
        this.trustManager = trustManager;
        return this;
    }

    public TlsConfigHelper createTrustManager(byte[] trustedCertsPem) {
        try {
            this.trustManager = this.tlsUtil.trustManager(trustedCertsPem);
        }
        catch (SSLException e) {
            throw new IllegalStateException("Error creating X509TrustManager with provided certs. Are they valid X.509 in PEM format?", e);
        }
        return this;
    }

    public TlsConfigHelper createKeyManager(byte[] privateKeyPem, byte[] certificatePem) {
        try {
            if (this.keyManager != null) {
                logger.warning("Previous X509 Key manager is being replaced. This is probably an error and should only be set once.");
            }
            this.keyManager = this.tlsUtil.keyManager(privateKeyPem, certificatePem);
            return this;
        }
        catch (SSLException e) {
            throw new IllegalStateException("Error creating X509KeyManager with provided certs. Are they valid X.509 in PEM format?", e);
        }
    }

    public TlsConfigHelper setKeyManager(X509KeyManager keyManager) {
        if (this.keyManager != null) {
            logger.warning("Previous X509 Key manager is being replaced. This is probably an error and should only be set once.");
        }
        this.keyManager = keyManager;
        return this;
    }

    public TlsConfigHelper setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    public void configureWithKeyManager(KeyManagerConfigurer configurer) {
        if (this.trustManager == null) {
            return;
        }
        try {
            configurer.configure(this.trustManager, this.keyManager);
        }
        catch (SSLException e) {
            TlsConfigHelper.wrapException(e);
        }
    }

    public void configureWithSocketFactory(SslSocketFactoryConfigurer configurer) {
        if (this.trustManager == null) {
            this.warnIfOtherComponentsConfigured();
            return;
        }
        try {
            SSLSocketFactory sslSocketFactory = this.sslSocketFactory;
            if (sslSocketFactory == null) {
                sslSocketFactory = this.tlsUtil.sslSocketFactory(this.keyManager, this.trustManager);
            }
            configurer.configure(sslSocketFactory, this.trustManager);
        }
        catch (SSLException e) {
            TlsConfigHelper.wrapException(e);
        }
    }

    private static void wrapException(SSLException e) {
        throw new IllegalStateException("Could not configure TLS connection, are certs in valid X.509 in PEM format?", e);
    }

    private void warnIfOtherComponentsConfigured() {
        if (this.sslSocketFactory != null) {
            logger.warning("sslSocketFactory has been configured without an X509TrustManager.");
            return;
        }
        if (this.keyManager != null) {
            logger.warning("An X509KeyManager has been configured without an X509TrustManager.");
        }
    }

    static interface TlsUtility {
        default public SSLSocketFactory sslSocketFactory(@Nullable X509KeyManager keyManager, X509TrustManager trustManager) throws SSLException {
            return TlsUtil.sslSocketFactory(keyManager, trustManager);
        }

        default public X509TrustManager trustManager(byte[] trustedCertificatesPem) throws SSLException {
            return TlsUtil.trustManager(trustedCertificatesPem);
        }

        default public X509KeyManager keyManager(byte[] privateKeyPem, byte[] certificatePem) throws SSLException {
            return TlsUtil.keyManager(privateKeyPem, certificatePem);
        }
    }

    public static interface KeyManagerConfigurer {
        public void configure(X509TrustManager var1, @Nullable X509KeyManager var2) throws SSLException;
    }

    public static interface SslSocketFactoryConfigurer {
        public void configure(SSLSocketFactory var1, X509TrustManager var2) throws SSLException;
    }
}

