/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ranger;

import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.validation.FileExists;
import jakarta.validation.constraints.NotEmpty;
import java.io.File;
import java.util.List;

public class RangerConfig {
    private String serviceName;
    private List<File> pluginConfigResource = ImmutableList.of();
    private List<File> hadoopConfigResource = ImmutableList.of();

    @NotEmpty
    public String getServiceName() {
        return this.serviceName;
    }

    @Config(value="ranger.service.name")
    @ConfigDescription(value="Name of Ranger service containing policies to enforce")
    public RangerConfig setServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public List<@FileExists File> getPluginConfigResource() {
        return this.pluginConfigResource;
    }

    @Config(value="ranger.plugin.config.resource")
    @ConfigDescription(value="List of paths to Ranger plugin configuration files")
    public RangerConfig setPluginConfigResource(List<File> pluginConfigResource) {
        this.pluginConfigResource = ImmutableList.copyOf(pluginConfigResource);
        return this;
    }

    public List<@FileExists File> getHadoopConfigResource() {
        return this.hadoopConfigResource;
    }

    @Config(value="ranger.hadoop.config.resource")
    @ConfigDescription(value="List of paths to hadoop configuration files")
    public RangerConfig setHadoopConfigResource(List<File> hadoopConfigResource) {
        this.hadoopConfigResource = ImmutableList.copyOf(hadoopConfigResource);
        return this;
    }
}

