/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ranger;

import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.eventlistener.QueryCompletedEvent;
import io.trino.spi.eventlistener.QueryContext;
import io.trino.spi.eventlistener.QueryCreatedEvent;
import io.trino.spi.eventlistener.QueryMetadata;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

class RangerTrinoEventListener
implements EventListener {
    private final Map<String, QueryCreatedEvent> activeQueries = new ConcurrentHashMap<String, QueryCreatedEvent>();

    RangerTrinoEventListener() {
    }

    public Optional<String> getClientAddress(String queryId) {
        QueryCreatedEvent event = this.activeQueries.get(queryId);
        QueryContext context = event != null ? event.getContext() : null;
        return context != null && context.getRemoteClientAddress().isPresent() ? Optional.of((String)context.getRemoteClientAddress().get()) : Optional.empty();
    }

    public Optional<String> getQueryText(String queryId) {
        QueryCreatedEvent event = this.activeQueries.get(queryId);
        QueryMetadata metadata = event != null ? event.getMetadata() : null;
        return metadata != null ? Optional.of(metadata.getQuery()) : Optional.empty();
    }

    public Optional<Instant> getQueryTime(String queryId) {
        QueryCreatedEvent event = this.activeQueries.get(queryId);
        return event != null ? Optional.of(event.getCreateTime()) : Optional.empty();
    }

    public Optional<String> getClientType(String queryId) {
        QueryCreatedEvent event = this.activeQueries.get(queryId);
        QueryContext context = event != null ? event.getContext() : null;
        return context != null && context.getUserAgent().isPresent() ? Optional.of((String)context.getUserAgent().get()) : Optional.empty();
    }

    public void queryCreated(QueryCreatedEvent event) {
        this.activeQueries.put(event.getMetadata().getQueryId(), event);
    }

    public void queryCompleted(QueryCompletedEvent event) {
        this.activeQueries.remove(event.getMetadata().getQueryId());
    }
}

