/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.js.parser.ir.Module;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import com.oracle.truffle.js.runtime.objects.AbstractModuleRecord;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.collections.EconomicMap;

public abstract class CyclicModuleRecord
extends AbstractModuleRecord {
    private Status status;
    private int dfsIndex = -1;
    private int dfsAncestorIndex = -1;
    private final EconomicMap<Module.ModuleRequest, AbstractModuleRecord> loadedModules = EconomicMap.create();
    private CyclicModuleRecord cycleRoot = this;
    private final boolean hasTLA;
    private boolean asyncEvaluation;
    private long asyncEvaluationOrder;
    private PromiseCapabilityRecord topLevelPromiseCapability = null;
    private List<CyclicModuleRecord> asyncParentModules = null;
    private int pendingAsyncDependencies = 0;
    private Throwable evaluationError;
    private Object executionResult;

    protected CyclicModuleRecord(JSContext context, Source source, Object hostDefined) {
        this(context, source, hostDefined, false);
    }

    protected CyclicModuleRecord(JSContext context, Source source, Object hostDefined, boolean hasTLA) {
        super(context, source, hostDefined);
        this.hasTLA = hasTLA;
        this.status = Status.New;
    }

    public abstract List<Module.ModuleRequest> getRequestedModules();

    public abstract void initializeEnvironment(JSRealm var1);

    public abstract Object executeModule(JSRealm var1, PromiseCapabilityRecord var2);

    @Override
    public final JSPromiseObject evaluate(JSRealm realm) {
        return this.context.getEvaluator().moduleEvaluation(realm, this);
    }

    @Override
    public final void link(JSRealm realm) {
        this.context.getEvaluator().moduleLinking(realm, this);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final AbstractModuleRecord getLoadedModule(JSRealm realm, Module.ModuleRequest moduleRequest) {
        return (AbstractModuleRecord)this.loadedModules.get((Object)moduleRequest);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final AbstractModuleRecord addLoadedModule(JSRealm realm, Module.ModuleRequest moduleRequest, AbstractModuleRecord module) {
        return (AbstractModuleRecord)this.loadedModules.putIfAbsent((Object)moduleRequest, (Object)module);
    }

    @CompilerDirectives.TruffleBoundary
    public final AbstractModuleRecord getImportedModule(Module.ModuleRequest moduleRequest) {
        assert (this.loadedModules.containsKey((Object)moduleRequest)) : moduleRequest;
        return (AbstractModuleRecord)this.loadedModules.get((Object)moduleRequest);
    }

    public final Status getStatus() {
        return this.status;
    }

    public final void setStatus(Status status) {
        this.status = status;
    }

    public final boolean isLinked() {
        return this.getStatus().compareTo(Status.Linked) >= 0;
    }

    public final boolean hasBeenEvaluated() {
        return this.getStatus() == Status.Evaluated || this.getStatus() == Status.EvaluatingAsync;
    }

    public final void setUnlinked() {
        this.setStatus(Status.Unlinked);
        this.clearEnvironment();
        this.dfsIndex = -1;
        this.dfsAncestorIndex = -1;
    }

    public final Throwable getEvaluationError() {
        assert (this.hasBeenEvaluated());
        return this.evaluationError;
    }

    public final void setEvaluationError(Throwable evaluationError) {
        assert (this.hasBeenEvaluated());
        this.evaluationError = evaluationError;
    }

    public final Object getExecutionResult() {
        assert (this.hasBeenEvaluated());
        return this.executionResult;
    }

    public final void setExecutionResult(Object executionResult) {
        this.executionResult = executionResult;
    }

    public final Object getExecutionResultOrThrow() {
        assert (this.hasBeenEvaluated());
        Throwable error = this.getEvaluationError();
        if (error != null) {
            throw JSRuntime.rethrow(error);
        }
        Object result = this.getExecutionResult();
        assert (result != null);
        return result;
    }

    public final int getDFSIndex() {
        assert (this.dfsIndex >= 0);
        return this.dfsIndex;
    }

    public final void setDFSIndex(int dfsIndex) {
        this.dfsIndex = dfsIndex;
    }

    public final int getDFSAncestorIndex() {
        assert (this.dfsAncestorIndex >= 0);
        return this.dfsAncestorIndex;
    }

    public final void setDFSAncestorIndex(int dfsAncestorIndex) {
        this.dfsAncestorIndex = dfsAncestorIndex;
    }

    public final PromiseCapabilityRecord getTopLevelCapability() {
        return this.topLevelPromiseCapability;
    }

    public final void setTopLevelCapability(PromiseCapabilityRecord capability) {
        this.topLevelPromiseCapability = capability;
    }

    public final boolean isAsyncEvaluation() {
        return this.asyncEvaluation;
    }

    public final void setAsyncEvaluation(boolean asyncEvaluation) {
        this.asyncEvaluation = asyncEvaluation;
    }

    public final List<CyclicModuleRecord> getAsyncParentModules() {
        return this.asyncParentModules;
    }

    public final void setPendingAsyncDependencies(int value) {
        this.pendingAsyncDependencies = value;
    }

    public final void initAsyncParentModules() {
        assert (this.asyncParentModules == null);
        this.asyncParentModules = new ArrayList<CyclicModuleRecord>();
    }

    public final void incPendingAsyncDependencies() {
        ++this.pendingAsyncDependencies;
    }

    public final void decPendingAsyncDependencies() {
        --this.pendingAsyncDependencies;
    }

    public final void appendAsyncParentModules(CyclicModuleRecord moduleRecord) {
        this.asyncParentModules.add(moduleRecord);
    }

    public final int getPendingAsyncDependencies() {
        return this.pendingAsyncDependencies;
    }

    public final void setAsyncEvaluatingOrder(long order) {
        this.asyncEvaluationOrder = order;
    }

    public final long getAsyncEvaluatingOrder() {
        return this.asyncEvaluationOrder;
    }

    public final boolean hasTLA() {
        return this.hasTLA;
    }

    public final void setCycleRoot(CyclicModuleRecord module) {
        this.cycleRoot = module;
    }

    public final CyclicModuleRecord getCycleRoot() {
        return this.cycleRoot;
    }

    public static enum Status {
        New,
        Unlinked,
        Linking,
        Linked,
        Evaluating,
        EvaluatingAsync,
        Evaluated;

    }
}

