/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.tools.chromeinspector.objects.AbstractInspectorArray;
import com.oracle.truffle.tools.chromeinspector.objects.Inspector;
import java.util.Arrays;

final class Keys
extends AbstractInspectorArray {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final String[] names;

    Keys(String[] names) {
        this.names = names;
    }

    @Override
    int getArraySize() {
        return this.names.length;
    }

    @Override
    Object readArrayElement(long index) throws InvalidArrayIndexException {
        if (index < 0L || index >= (long)Inspector.NAMES.length) {
            CompilerDirectives.transferToInterpreter();
            throw InvalidArrayIndexException.create((long)index);
        }
        return this.names[(int)index];
    }

    @Override
    TriState isIdenticalOrUndefined(Object other) {
        if (other instanceof Keys) {
            Keys otherKeys = (Keys)other;
            return TriState.valueOf((this.names == otherKeys.names ? 1 : 0) != 0);
        }
        return TriState.UNDEFINED;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    int identityHashCode() {
        return Arrays.hashCode(this.names);
    }
}

