/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.types;

import com.oracle.truffle.tools.chromeinspector.types.CoverageRange;
import org.graalvm.shadowed.org.json.JSONArray;
import org.graalvm.shadowed.org.json.JSONObject;

public final class FunctionCoverage {
    private final String functionName;
    private final boolean isBlockCoverage;
    private final CoverageRange[] ranges;

    public FunctionCoverage(String functionName, boolean isBlockCoverage, CoverageRange ... ranges) {
        this.functionName = functionName;
        this.isBlockCoverage = isBlockCoverage;
        this.ranges = ranges;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public boolean isBlockCoverage() {
        return this.isBlockCoverage;
    }

    public CoverageRange[] getRanges() {
        return this.ranges;
    }

    private JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("functionName", (Object)this.functionName);
        json.put("ranges", (Object)CoverageRange.toJSON(this.ranges));
        json.put("isBlockCoverage", this.isBlockCoverage);
        return json;
    }

    static JSONArray toJSON(FunctionCoverage[] functions) {
        JSONArray array = new JSONArray();
        for (FunctionCoverage function : functions) {
            array.put((Object)function.toJSON());
        }
        return array;
    }
}

