/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.types;

import com.oracle.truffle.tools.chromeinspector.types.RemoteObject;
import org.graalvm.shadowed.org.json.JSONObject;

public final class PropertyDescriptor {
    private final JSONObject jsonObject;

    public PropertyDescriptor(String name, RemoteObject value, Boolean writable, RemoteObject get, RemoteObject set, boolean configurable, boolean enumerable, Boolean wasThrown, Boolean isOwn, RemoteObject symbol) {
        this.jsonObject = PropertyDescriptor.createJSON(name, value, writable, get, set, configurable, enumerable, wasThrown, isOwn, symbol);
    }

    private static JSONObject createJSON(String name, RemoteObject value, Boolean writable, RemoteObject get, RemoteObject set, boolean configurable, boolean enumerable, Boolean wasThrown, Boolean isOwn, RemoteObject symbol) {
        JSONObject json = new JSONObject();
        json.put("name", (Object)name);
        if (value != null && get == null) {
            json.put("value", (Object)value.toJSON());
        }
        json.putOpt("writable", (Object)writable);
        if (get != null) {
            json.put("get", (Object)get.toJSON());
        }
        if (set != null) {
            json.put("set", (Object)set.toJSON());
        }
        json.put("configurable", configurable);
        json.put("enumerable", enumerable);
        json.putOpt("wasThrown", (Object)wasThrown);
        json.putOpt("isOwn", (Object)isOwn);
        if (symbol != null) {
            json.put("symbol", (Object)symbol.toJSON());
        }
        return json;
    }

    public JSONObject toJSON() {
        return this.jsonObject;
    }
}

