/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.regex.AbstractConstantKeysObject;
import com.oracle.truffle.regex.util.TBitSet;
import com.oracle.truffle.regex.util.TruffleReadOnlyKeysArray;

@ExportLibrary(value=InteropLibrary.class)
public final class JavaFlags
extends AbstractConstantKeysObject {
    private static final String PROP_CANON_EQ = "CANON_EQ";
    private static final String PROP_UNICODE_CHARACTER_CLASS = "UNICODE_CHARACTER_CLASS";
    private static final String PROP_UNIX_LINES = "UNIX_LINES";
    private static final String PROP_CASE_INSENSITIVE = "CASE_INSENSITIVE";
    private static final String PROP_MULTILINE = "MULTILINE";
    private static final String PROP_DOTALL = "DOTALL";
    private static final String PROP_UNICODE_CASE = "UNICODE_CASE";
    private static final String PROP_COMMENTS = "COMMENTS";
    private static final String PROP_LITERAL = "LITERAL";
    private static final TruffleReadOnlyKeysArray KEYS = new TruffleReadOnlyKeysArray("CANON_EQ", "UNICODE_CHARACTER_CLASS", "UNIX_LINES", "CASE_INSENSITIVE", "MULTILINE", "DOTALL", "UNICODE_CASE", "COMMENTS", "LITERAL");
    private static final TBitSet FLAGS = TBitSet.valueOf(85, 99, 100, 105, 108, 109, 115, 117, 120);
    private final int value;

    public JavaFlags(int bits) {
        this.value = bits;
    }

    public static JavaFlags parseFlags(String source) {
        int flags = 0;
        block11: for (int i = 0; i < source.length(); ++i) {
            char ch = source.charAt(i);
            switch (ch) {
                case 'c': {
                    flags |= 0x80;
                    continue block11;
                }
                case 'U': {
                    flags |= 0x100;
                    continue block11;
                }
                case 'd': {
                    flags |= 1;
                    continue block11;
                }
                case 'i': {
                    flags |= 2;
                    continue block11;
                }
                case 'm': {
                    flags |= 8;
                    continue block11;
                }
                case 's': {
                    flags |= 0x20;
                    continue block11;
                }
                case 'u': {
                    flags |= 0x40;
                    continue block11;
                }
                case 'x': {
                    flags |= 4;
                    continue block11;
                }
                case 'l': {
                    flags |= 0x10;
                }
            }
        }
        return new JavaFlags(flags);
    }

    private static int maskForFlag(int flagChar) {
        switch (flagChar) {
            case 99: {
                return 128;
            }
            case 85: {
                return 256;
            }
            case 100: {
                return 1;
            }
            case 105: {
                return 2;
            }
            case 109: {
                return 8;
            }
            case 115: {
                return 32;
            }
            case 117: {
                return 64;
            }
            case 120: {
                return 4;
            }
            case 108: {
                return 16;
            }
        }
        throw new IllegalStateException("should not reach here");
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        StringBuilder sb = new StringBuilder(KEYS.size());
        if (this.isSet(128)) {
            sb.append('c');
        }
        if (this.isSet(256)) {
            sb.append('U');
        }
        if (this.isSet(1)) {
            sb.append('d');
        }
        if (this.isSet(2)) {
            sb.append('i');
        }
        if (this.isSet(8)) {
            sb.append('m');
        }
        if (this.isSet(32)) {
            sb.append('s');
        }
        if (this.isSet(64)) {
            sb.append('u');
        }
        if (this.isSet(4)) {
            sb.append('x');
        }
        if (this.isSet(16)) {
            sb.append('l');
        }
        return sb.toString();
    }

    public int getValue() {
        return this.value;
    }

    public boolean isCanonEq() {
        return this.isSet(128);
    }

    public boolean isUnicodeCharacterClass() {
        return this.isSet(256);
    }

    public boolean isUnixLines() {
        return this.isSet(1);
    }

    public boolean isCaseInsensitive() {
        return this.isSet(2);
    }

    public boolean isMultiline() {
        return this.isSet(8);
    }

    public boolean isDotAll() {
        return this.isSet(32);
    }

    public boolean isComments() {
        return this.isSet(4);
    }

    public boolean isUnicodeCase() {
        return this.isSet(64);
    }

    public boolean isLiteral() {
        return this.isSet(16);
    }

    private boolean isSet(int flag) {
        return (this.value & flag) != 0;
    }

    public JavaFlags addFlag(int flagChar) {
        return new JavaFlags(this.value | JavaFlags.maskForFlag(flagChar));
    }

    public JavaFlags delFlag(int flagChar) {
        return new JavaFlags(this.value & ~JavaFlags.maskForFlag(flagChar));
    }

    public static boolean isValidFlagChar(int candidateChar) {
        return FLAGS.get(candidateChar);
    }

    public boolean equals(Object other) {
        return other instanceof JavaFlags && this.value == ((JavaFlags)other).value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public Object toDisplayString(boolean allowSideEffects) {
        return "TRegexJavaFlags{flags=" + String.valueOf(this) + "}";
    }

    @Override
    public TruffleReadOnlyKeysArray getKeys() {
        return KEYS;
    }

    @Override
    public boolean isMemberReadableImpl(String symbol) {
        switch (symbol) {
            case "CANON_EQ": 
            case "UNICODE_CHARACTER_CLASS": 
            case "UNIX_LINES": 
            case "CASE_INSENSITIVE": 
            case "MULTILINE": 
            case "DOTALL": 
            case "UNICODE_CASE": 
            case "COMMENTS": 
            case "LITERAL": {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object readMemberImpl(String symbol) throws UnknownIdentifierException {
        switch (symbol) {
            case "CANON_EQ": {
                return this.isCanonEq();
            }
            case "UNICODE_CHARACTER_CLASS": {
                return this.isUnicodeCharacterClass();
            }
            case "UNIX_LINES": {
                return this.isUnixLines();
            }
            case "CASE_INSENSITIVE": {
                return this.isCaseInsensitive();
            }
            case "MULTILINE": {
                return this.isMultiline();
            }
            case "DOTALL": {
                return this.isDotAll();
            }
            case "UNICODE_CASE": {
                return this.isUnicodeCase();
            }
            case "COMMENTS": {
                return this.isComments();
            }
            case "LITERAL": {
                return this.isLiteral();
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw UnknownIdentifierException.create((String)symbol);
    }
}

