/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop;

import com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

public final class ConfigurationInstantiator {
    private ConfigurationInstantiator() {
    }

    public static Configuration newEmptyConfiguration() {
        return ConfigurationInstantiator.newConfiguration(false);
    }

    public static Configuration newConfigurationWithDefaultResources() {
        return ConfigurationInstantiator.newConfiguration(true);
    }

    private static Configuration newConfiguration(boolean loadDefaults) {
        ClassLoader expectedClassLoader;
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Preconditions.checkState((tccl == (expectedClassLoader = ConfigurationInstantiator.class.getClassLoader()) ? 1 : 0) != 0, (String)"During instantiation, the Configuration object captures the TCCL and uses it to resolve classes by name. For this reason, the current TCCL %s should be same as this class's classloader %s. Otherwise the constructed Configuration will use *some* classloader to resolve classes", (Object)tccl, (Object)expectedClassLoader);
        return ConfigurationInstantiator.newConfigurationWithTccl(loadDefaults);
    }

    @SuppressModernizer
    private static Configuration newConfigurationWithTccl(boolean loadDefaults) {
        return new Configuration(loadDefaults);
    }
}

