/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.airlift.http.client.HeaderName;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.ResponseHandlerUtils;
import java.util.List;
import javax.annotation.Nullable;

public class StatusResponseHandler
implements ResponseHandler<StatusResponse, RuntimeException> {
    private static final StatusResponseHandler statusResponseHandler = new StatusResponseHandler();

    public static StatusResponseHandler createStatusResponseHandler() {
        return statusResponseHandler;
    }

    private StatusResponseHandler() {
    }

    @Override
    public StatusResponse handleException(Request request, Exception exception) {
        throw ResponseHandlerUtils.propagate(request, exception);
    }

    @Override
    public StatusResponse handle(Request request, Response response) {
        return new StatusResponse(response.getStatusCode(), response.getHeaders());
    }

    public static class StatusResponse {
        private final int statusCode;
        private final ListMultimap<HeaderName, String> headers;

        public StatusResponse(int statusCode, ListMultimap<HeaderName, String> headers) {
            this.statusCode = statusCode;
            this.headers = ImmutableListMultimap.copyOf(headers);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        @Nullable
        public String getHeader(String name) {
            List values = this.getHeaders().get((Object)HeaderName.of(name));
            return values.isEmpty() ? null : (String)values.get(0);
        }

        public List<String> getHeaders(String name) {
            return this.headers.get((Object)HeaderName.of(name));
        }

        public ListMultimap<HeaderName, String> getHeaders() {
            return this.headers;
        }
    }
}

