/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.writer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.trino.orc.checkpoint.BooleanStreamCheckpoint;
import io.trino.orc.metadata.ColumnEncoding;
import io.trino.orc.metadata.CompressedMetadataWriter;
import io.trino.orc.metadata.CompressionKind;
import io.trino.orc.metadata.OrcColumnId;
import io.trino.orc.metadata.RowGroupIndex;
import io.trino.orc.metadata.Stream;
import io.trino.orc.metadata.statistics.ColumnStatistics;
import io.trino.orc.stream.PresentOutputStream;
import io.trino.orc.stream.StreamDataOutput;
import io.trino.orc.writer.ColumnWriter;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarRow;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class StructColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(StructColumnWriter.class).instanceSize();
    private static final ColumnEncoding COLUMN_ENCODING = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT, 0);
    private final OrcColumnId columnId;
    private final boolean compressed;
    private final PresentOutputStream presentStream;
    private final List<ColumnWriter> structFields;
    private final List<ColumnStatistics> rowGroupColumnStatistics = new ArrayList<ColumnStatistics>();
    private int nonNullValueCount;
    private boolean closed;

    public StructColumnWriter(OrcColumnId columnId, CompressionKind compression, int bufferSize, List<ColumnWriter> structFields) {
        this.columnId = columnId;
        this.compressed = Objects.requireNonNull(compression, "compression is null") != CompressionKind.NONE;
        this.structFields = ImmutableList.copyOf((Collection)Objects.requireNonNull(structFields, "structFields is null"));
        this.presentStream = new PresentOutputStream(compression, bufferSize);
    }

    @Override
    public List<ColumnWriter> getNestedColumnWriters() {
        ImmutableList.Builder nestedColumnWriters = ImmutableList.builder();
        for (ColumnWriter structField : this.structFields) {
            nestedColumnWriters.add((Object)structField).addAll(structField.getNestedColumnWriters());
        }
        return nestedColumnWriters.build();
    }

    @Override
    public Map<OrcColumnId, ColumnEncoding> getColumnEncodings() {
        ImmutableMap.Builder encodings = ImmutableMap.builder();
        encodings.put((Object)this.columnId, (Object)COLUMN_ENCODING);
        this.structFields.stream().map(ColumnWriter::getColumnEncodings).forEach(arg_0 -> ((ImmutableMap.Builder)encodings).putAll(arg_0));
        return encodings.buildOrThrow();
    }

    @Override
    public void beginRowGroup() {
        this.presentStream.recordCheckpoint();
        this.structFields.forEach(ColumnWriter::beginRowGroup);
    }

    @Override
    public void writeBlock(Block block) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((block.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Block is empty");
        ColumnarRow columnarRow = ColumnarRow.toColumnarRow((Block)block);
        this.writeColumnarRow(columnarRow);
    }

    private void writeColumnarRow(ColumnarRow columnarRow) {
        for (int position = 0; position < columnarRow.getPositionCount(); ++position) {
            boolean present = !columnarRow.isNull(position);
            this.presentStream.writeBoolean(present);
            if (!present) continue;
            ++this.nonNullValueCount;
        }
        for (int i = 0; i < this.structFields.size(); ++i) {
            ColumnWriter columnWriter = this.structFields.get(i);
            Block fieldBlock = columnarRow.getField(i);
            if (fieldBlock.getPositionCount() <= 0) continue;
            columnWriter.writeBlock(fieldBlock);
        }
    }

    @Override
    public Map<OrcColumnId, ColumnStatistics> finishRowGroup() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ColumnStatistics statistics = new ColumnStatistics(Long.valueOf(this.nonNullValueCount), 0L, null, null, null, null, null, null, null, null, null, null);
        this.rowGroupColumnStatistics.add(statistics);
        this.nonNullValueCount = 0;
        ImmutableMap.Builder columnStatistics = ImmutableMap.builder();
        columnStatistics.put((Object)this.columnId, (Object)statistics);
        this.structFields.stream().map(ColumnWriter::finishRowGroup).forEach(arg_0 -> ((ImmutableMap.Builder)columnStatistics).putAll(arg_0));
        return columnStatistics.buildOrThrow();
    }

    @Override
    public void close() {
        this.closed = true;
        this.structFields.forEach(ColumnWriter::close);
        this.presentStream.close();
    }

    @Override
    public Map<OrcColumnId, ColumnStatistics> getColumnStripeStatistics() {
        Preconditions.checkState((boolean)this.closed);
        ImmutableMap.Builder columnStatistics = ImmutableMap.builder();
        columnStatistics.put((Object)this.columnId, (Object)ColumnStatistics.mergeColumnStatistics(this.rowGroupColumnStatistics));
        this.structFields.stream().map(ColumnWriter::getColumnStripeStatistics).forEach(arg_0 -> ((ImmutableMap.Builder)columnStatistics).putAll(arg_0));
        return columnStatistics.buildOrThrow();
    }

    @Override
    public List<StreamDataOutput> getIndexStreams(CompressedMetadataWriter metadataWriter) throws IOException {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder rowGroupIndexes = ImmutableList.builder();
        Optional<List<BooleanStreamCheckpoint>> presentCheckpoints = this.presentStream.getCheckpoints();
        int i = 0;
        while (i < this.rowGroupColumnStatistics.size()) {
            int groupId = i++;
            ColumnStatistics columnStatistics = this.rowGroupColumnStatistics.get(groupId);
            Optional<BooleanStreamCheckpoint> presentCheckpoint = presentCheckpoints.map(checkpoints -> (BooleanStreamCheckpoint)checkpoints.get(groupId));
            List<Integer> positions = StructColumnWriter.createStructColumnPositionList(this.compressed, presentCheckpoint);
            rowGroupIndexes.add((Object)new RowGroupIndex(positions, columnStatistics));
        }
        Slice slice = metadataWriter.writeRowIndexes((List<RowGroupIndex>)rowGroupIndexes.build());
        Stream stream = new Stream(this.columnId, Stream.StreamKind.ROW_INDEX, slice.length(), false);
        ImmutableList.Builder indexStreams = ImmutableList.builder();
        indexStreams.add((Object)new StreamDataOutput(slice, stream));
        for (ColumnWriter structField : this.structFields) {
            indexStreams.addAll(structField.getIndexStreams(metadataWriter));
            indexStreams.addAll(structField.getBloomFilters(metadataWriter));
        }
        return indexStreams.build();
    }

    @Override
    public List<StreamDataOutput> getBloomFilters(CompressedMetadataWriter metadataWriter) {
        return ImmutableList.of();
    }

    private static List<Integer> createStructColumnPositionList(boolean compressed, Optional<BooleanStreamCheckpoint> presentCheckpoint) {
        ImmutableList.Builder positionList = ImmutableList.builder();
        presentCheckpoint.ifPresent(booleanStreamCheckpoint -> positionList.addAll(booleanStreamCheckpoint.toPositionList(compressed)));
        return positionList.build();
    }

    @Override
    public List<StreamDataOutput> getDataStreams() {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder outputDataStreams = ImmutableList.builder();
        this.presentStream.getStreamDataOutput(this.columnId).ifPresent(arg_0 -> ((ImmutableList.Builder)outputDataStreams).add(arg_0));
        for (ColumnWriter structField : this.structFields) {
            outputDataStreams.addAll(structField.getDataStreams());
        }
        return outputDataStreams.build();
    }

    @Override
    public long getBufferedBytes() {
        long bufferedBytes = this.presentStream.getBufferedBytes();
        for (ColumnWriter structField : this.structFields) {
            bufferedBytes += structField.getBufferedBytes();
        }
        return bufferedBytes;
    }

    @Override
    public long getRetainedBytes() {
        long retainedBytes = (long)INSTANCE_SIZE + this.presentStream.getRetainedBytes();
        for (ColumnWriter structField : this.structFields) {
            retainedBytes += structField.getRetainedBytes();
        }
        for (ColumnStatistics statistics : this.rowGroupColumnStatistics) {
            retainedBytes += statistics.getRetainedSizeInBytes();
        }
        return retainedBytes;
    }

    @Override
    public void reset() {
        this.closed = false;
        this.presentStream.reset();
        this.structFields.forEach(ColumnWriter::reset);
        this.rowGroupColumnStatistics.clear();
        this.nonNullValueCount = 0;
    }
}

